# -*- coding: utf-8 -*-
import types

from rpc_framework.views import RPCView


def rpc_view(endpoint):
    """
    Decorator that converts a function-based view into an RPCView subclass.
    """
    def decorator(func):

        WrappedAPIView = type(
            'WrappedAPIView',
            (RPCView,),
            {'__doc__': func.__doc__}
        )

        WrappedAPIView.endpoint = endpoint
        def handler(self, context, *args, **kwargs):
            return func(context, *args, **kwargs)

        setattr(WrappedAPIView, 'handler', handler)
        setattr(WrappedAPIView, 'callee', func)

        WrappedAPIView.__name__ = func.__name__
        WrappedAPIView.__module__ = func.__module__

        # WrappedAPIView.renderer_classes = getattr(func, 'renderer_classes',
        #                                           RPCView.renderer_classes)

        WrappedAPIView.parser_classes = getattr(func, 'parser_classes',
                                                RPCView.parser_classes)

        WrappedAPIView.interceptor_classes = getattr(func, 'interceptor_classes',
                                                     RPCView.interceptor_classes)

        WrappedAPIView.authentication_classes = getattr(func, 'authentication_classes',
                                                        RPCView.authentication_classes)

        WrappedAPIView.throttle_classes = getattr(func, 'throttle_classes',
                                                  RPCView.throttle_classes)

        WrappedAPIView.permission_classes = getattr(func, 'permission_classes',
                                                    RPCView.permission_classes)

        # WrappedAPIView.schema = getattr(func, 'schema', RPCView.schema)

        return WrappedAPIView.rpc_bind()

    return decorator

def renderer_classes(renderer_classes):
    def decorator(func):
        func.renderer_classes = renderer_classes
        return func
    return decorator


def parser_classes(parser_classes):
    def decorator(func):
        func.parser_classes = parser_classes
        return func
    return decorator


def interceptor_classes(interceptor_classes):
    def decorator(func):
        func.interceptor_classes = interceptor_classes
        return func

    return decorator


def authentication_classes(authentication_classes):
    def decorator(func):
        func.authentication_classes = authentication_classes
        return func
    return decorator


def throttle_classes(throttle_classes):
    def decorator(func):
        func.throttle_classes = throttle_classes
        return func
    return decorator


def permission_classes(permission_classes):
    def decorator(func):
        func.permission_classes = permission_classes
        return func
    return decorator


def schema(view_inspector):
    def decorator(func):
        func.schema = view_inspector
        return func
    return decorator
