# -*- coding: utf-8 -*-
from datetime import datetime, date, timedelta, timezone
from typing import Union


def get_timestamp_epoch(the_time: Union[date, datetime, None]):
    if the_time is None:
        return None

    if isinstance(the_time, datetime):
        pass
    elif isinstance(the_time, date):
        the_time = datetime(the_time.year, the_time.month, the_time.day)
    else:
        raise TypeError(
            "datetime.datetime or datetime.date expected. [%s]" % type(
                the_time))
    return int(the_time.timestamp())


def get_timestamp(the_time: Union[date, datetime]):
    return get_timestamp_epoch(the_time)


def get_timestamp_or_none(the_time: Union[date, datetime, None]):
    return get_timestamp(the_time) if the_time is not None else None
