# -*- coding: utf-8 -*-
from django.conf import settings


class MessageRouter(object):
    MODEL_PREFIXS = 'api.models.message'
    TABLES = ['api_conversation', 'api_conversationuserstatus', 'api_message', 'api_conversationtags']

    def validate(self, model):
        return model.__module__.startswith(self.MODEL_PREFIXS) and model._meta.db_table in self.TABLES

    def db_for_read(self, model, **hints):
        if self.validate(model):
            return getattr(settings, 'MESSAGE_SLAVE_DB_NAME', settings.MESSAGE_DB_NAME)
        return None

    def db_for_write(self, model, **hints):
        if self.validate(model):
            return settings.MESSAGE_DB_NAME
        return None

    def allow_relation(self, obj1, obj2, **hints):
        if self.validate(obj1) and self.validate(obj2):
            return True
        return None

    def allow_migrate(self, db, app_label, model_name=None, **hints):
        return True
