"""courier URL Configuration

The `urlpatterns` list routes URLs to views. For more information please see:
    https://docs.djangoproject.com/en/3.0/topics/http/urls/
Examples:
Function views
    1. Add an import:  from my_app import views
    2. Add a URL to urlpatterns:  path('', views.home, name='home')
Class-based views
    1. Add an import:  from other_app.views import Home
    2. Add a URL to urlpatterns:  path('', Home.as_view(), name='home')
Including another URLconf
    1. Import the include() function: from django.urls import include, path
    2. Add a URL to urlpatterns:  path('blog/', include('blog.urls'))
"""
from django.contrib import admin
from django.urls import path
from adapter.rpcd import views

urlpatterns = [
    path('ping', views.PingView.as_view()),
    path('version', views.ServerVersionView.as_view()),
    path('system/statuses', views.SystemStatusesView.as_view()),
    path('v1/once', views.V1OnceView.as_view()),
    path('v1/batch', views.V1BatchView.as_view()),

    path('admin/', admin.site.urls),
]
