# -*- coding: utf-8 -*-
from typing import List, Dict, Optional, Set, Tuple

from . import rpc_invoke_error_handle_decorator
from .context import get_rpc_remote_invoker


@rpc_invoke_error_handle_decorator
def get_doctor_info(user_id: str) -> Dict:
    return get_rpc_remote_invoker()['api/doctor'](
        user_id=user_id,
    ).unwrap()


@rpc_invoke_error_handle_decorator
def batch_get_doctor_info_by_doctor_ids(doctor_ids, with_fields=None) -> List[Dict]:
    return get_rpc_remote_invoker()['api/batch_get_doctor_info_by_doctor_ids'](
        doctor_ids=doctor_ids,
        with_fields=with_fields
    ).unwrap()


def get_message_mark_user(user_id_list: List[int],
                          target_user_id_list: List[int]) \
        -> List[Dict]:
    return get_rpc_remote_invoker()['gaia/courier/mark_user'](
        user_id_list=user_id_list,
        target_user_id_list=target_user_id_list
    ).unwrap()


@rpc_invoke_error_handle_decorator
def get_toc_hospital_basic_info(hospital_id: str,
                                with_fields: Optional[List[str]]=['meta']):
    return get_rpc_remote_invoker()['api/get_toc_hospital_basic_info'](
        hospital_id=hospital_id,
        with_fields=with_fields
    ).unwrap()


def get_doctor_basic_info(doctor_ids: List[str]) -> List[Dict]:
    return get_rpc_remote_invoker()['api/doctor/basic_info'](
        doctor_ids=doctor_ids
    ).unwrap()


def get_single_doctor_basic_info(doctor_id: str) -> Dict:
    res = get_rpc_remote_invoker()['api/doctor/basic_info'](
        doctor_ids=[doctor_id]
    ).unwrap()
    if res:
        return res[0]

def get_fans_relationship(user_id1:str, user_id2:str) -> Tuple[bool, bool]:
    # response:
    # value1: user2 是否 user1 的粉丝
    # value2: user1 是否 user2 的粉丝
    try:
        return get_rpc_remote_invoker()['api/get_fans_relationship'](
            user_id1=user_id1,
            user_id2=user_id2
        ).unwrap()
    except:
        return [False, False]


def batch_get_doctor_info_by_user_ids(user_ids: List[int]) -> Dict:
    return get_rpc_remote_invoker()['api/batch_get_doctor_info_by_user_ids'](
        user_ids=user_ids,
        with_fields=['meta']
    ).unwrap()

def get_user_info_by_user_id(user_id):
    return get_rpc_remote_invoker()['hera/user/getinfoby_userid'](user_id=user_id).unwrap()


def is_kefu_user(user_id):
    try:
        get_rpc_remote_invoker()['api/is_kefu_user'](user_id=user_id).unwrap()
    except:
        return False