"""
Django settings for courier project.

Generated by 'django-admin startproject' using Django 3.0.1.

For more information on this file, see
https://docs.djangoproject.com/en/3.0/topics/settings/

For the full list of settings and their values, see
https://docs.djangoproject.com/en/3.0/ref/settings/
"""

import os

# Build paths inside the project like this: os.path.join(BASE_DIR, ...)
BASE_DIR = os.path.dirname(os.path.dirname(os.path.abspath(__file__)))


# Quick-start development settings - unsuitable for production
# See https://docs.djangoproject.com/en/3.0/howto/deployment/checklist/

# SECURITY WARNING: keep the secret key used in production secret!
SECRET_KEY = 'd2#)2cd!efrj@to&45yn=+=82-b*&of3i*&fxgfq%v53h1&1qx'

# SECURITY WARNING: don't run with debug turned on in production!
DEBUG = True

ALLOWED_HOSTS = ['*']


# Application definition

INSTALLED_APPS = [
    'django.contrib.admin',
    'django.contrib.auth',
    'django.contrib.contenttypes',
    # 'django.contrib.sessions',
    'django.contrib.messages',
    # 'django.contrib.staticfiles',
    'api'
]

MIDDLEWARE = [
    'gm_tracer.middleware.TracerMiddleware',
    'django.middleware.security.SecurityMiddleware',
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.middleware.common.CommonMiddleware',
    # 'django.middleware.csrf.CsrfViewMiddleware',
    'django.contrib.auth.middleware.AuthenticationMiddleware',
    'django.contrib.messages.middleware.MessageMiddleware',
    'django.middleware.clickjacking.XFrameOptionsMiddleware',
    'adapter.tracer.middleware.TracerMiddleware',
]

ROOT_URLCONF = 'courier.urls'

TEMPLATES = [
    {
        'BACKEND': 'django.template.backends.django.DjangoTemplates',
        'DIRS': [],
        'APP_DIRS': True,
        'OPTIONS': {
            'context_processors': [
                'django.template.context_processors.debug',
                'django.template.context_processors.request',
                'django.contrib.auth.context_processors.auth',
                'django.contrib.messages.context_processors.messages',
            ],
        },
    },
]

WSGI_APPLICATION = 'courier.wsgi.application'


# Database
# https://docs.djangoproject.com/en/3.0/ref/settings/#databases

DATABASES = {
    'default': {
        'ENGINE': 'django.db.backends.mysql',
        'NAME': 'whisper_test',
        'USER': 'work',
        'PASSWORD': 'Gengmei1',
        'HOST': 'bj-cdb-6slgqwlc.sql.tencentcdb.com',
        'PORT': '62120',
        'OPTIONS': {
            "init_command": "SET foreign_key_checks = 0;",
            "charset": "utf8mb4",
        },
    },
    'slave': {
        'ENGINE': 'django.db.backends.mysql',
        'NAME': 'whisper_test',
        'USER': 'work',
        'PASSWORD': 'Gengmei1',
        'HOST': 'bj-cdb-6slgqwlc.sql.tencentcdb.com',
        'PORT': '62120',
        'OPTIONS': {
            "init_command": "SET foreign_key_checks = 0;",
            "charset": "utf8mb4",
        },
    },
}


# Password validation
# https://docs.djangoproject.com/en/3.0/ref/settings/#auth-password-validators

AUTH_PASSWORD_VALIDATORS = [
    {
        'NAME': 'django.contrib.auth.password_validation.UserAttributeSimilarityValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.MinimumLengthValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.CommonPasswordValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.NumericPasswordValidator',
    },
]


# Internationalization
# https://docs.djangoproject.com/en/3.0/topics/i18n/

LANGUAGE_CODE = 'en-us'

TIME_ZONE = 'Asia/Shanghai'

USE_I18N = True

USE_L10N = True

USE_TZ = True


# Static files (CSS, JavaScript, Images)
# https://docs.djangoproject.com/en/3.0/howto/static-files/

STATIC_URL = '/static/'



#######################################################
####################### LOGGING #######################
#######################################################
# https://docs.djangoproject.com/en/3.0/topics/logging/
# django.utils.log:18,   django.conf.global_settings:561
PROJECT_LOG_PATH = '/data/log/courier/app'
if not os.path.exists(PROJECT_LOG_PATH):
    try:
        os.makedirs(PROJECT_LOG_PATH, exist_ok=True)
    except PermissionError:
        PROJECT_LOG_PATH = os.path.join(BASE_DIR, 'log')
        os.makedirs(PROJECT_LOG_PATH, exist_ok=True)

LOGGING = {
    'version': 1,
    'disable_existing_loggers': False,
    'filters': {
        'require_debug_false': {
            '()': 'django.utils.log.RequireDebugFalse',
        },
        'require_debug_true': {
            '()': 'django.utils.log.RequireDebugTrue',
        },
    },
    'formatters': {
        'verbose': {
            "format": "[%(asctime)-23s]:%(levelname)s:@%(pathname)s:%(lineno)d, "
                      "%(funcName)s: %(message)s",
            # "datefmt": "%Y-%m-%d %H:%M:%S.%f%z"
        },
        'raw': {
            'format': '%(message)s',
        },

    },
    'handlers': {
        'console': {
            'level': 'INFO',
            'filters': ['require_debug_true'],
            'class': 'logging.StreamHandler',
            'formatter': 'verbose'
        },
        'django': {
            'level': 'INFO',
            'class': 'logging.handlers.TimedRotatingFileHandler',
            'filename': os.path.join(PROJECT_LOG_PATH, 'django.log'),
            'when': 'midnight',
            'interval': 1,
            'backupCount': 365,
            'formatter': 'verbose'
        },
        'default': {
            'level': 'DEBUG',
            'class': 'logging.handlers.TimedRotatingFileHandler',
            'filename': os.path.join(PROJECT_LOG_PATH, 'default.log'),
            'when': 'midnight',
            'interval': 1,
            'backupCount': 365,
            'formatter': 'verbose'
        },
        'exception_logger_handler': {
            'level': 'INFO',
            'class': 'logging.handlers.RotatingFileHandler',
            'filename': os.path.join(PROJECT_LOG_PATH, 'exception_logger.log'),
            'formatter': 'raw',
        },
        'info_logger_handler': {
            'level': 'INFO',
            'class': 'logging.handlers.RotatingFileHandler',
            'filename': os.path.join(PROJECT_LOG_PATH, 'info_logger.log'),
            'formatter': 'verbose',
        },
    },
    'loggers': {
        '': {
            'handlers': ['default', 'console'],
            'level': 'DEBUG' if DEBUG else 'WARNING', # default level is warning
        },
        'django': {
            'handlers': ['django', 'console'],
            'level': 'DEBUG' if DEBUG else 'WARNING',
            'propagate': False
        },
        'django.request': {
            'handlers': ['django', 'console'],
            'level': 'DEBUG' if DEBUG else 'WARNING',
            'propagate': False
        },
        'exception_logger': {
            'handlers': ['exception_logger_handler'],
            'level': 'INFO',
            'propagate': False,
        },
        'info_logger': {
            'handlers': ['info_logger_handler'],
            'level': 'INFO',
            'propagate': False,
        },

        # debug
        'kafka': {
            'level': 'FATAL'
        },
        'sentry': {
            'level': 'FATAL'
        },
    }
}

# optimize SQL
if DEBUG:
    LOGGING['loggers'].update({
        'django.db.backends': {
            'handlers': ['console'],
            'propagate': True,
            'level': 'DEBUG',
        }
    }),

GMTRACER_PARSER = 'adapter.tracer.setup_tracer'

try:
    from courier.settings_local import *
except ModuleNotFoundError:
    pass

COUNT_LIMIT = 100
ES_SEARCH_TIMEOUT = '10s'
DATABASE_ROUTERS = ['courier.db_routers.MessageRouter']
MESSAGE_DB_NAME = 'default'
MESSAGE_SLAVE_DB_NAME = 'slave'