# -*- coding: utf-8 -*-
import types

from rpc_framework.views import RPCView


def rpc_view(endpoint):
    """
    Decorator that converts a function-based view into an RPCView subclass.
    """
    def decorator(func):

        WrappedAPIView = type(
            'WrappedAPIView',
            (RPCView,),
            {'__doc__': func.__doc__}
        )

        WrappedAPIView.endpoint = endpoint
        def handler(self, context, *args, **kwargs):
            return func(context, *args, **kwargs)
        setattr(WrappedAPIView, 'handler', handler)

        WrappedAPIView.__name__ = func.__name__
        WrappedAPIView.__module__ = func.__module__

        # WrappedAPIView.renderer_classes = getattr(func, 'renderer_classes',
        #                                           RPCView.renderer_classes)

        WrappedAPIView.parser_classes = getattr(func, 'parser_classes',
                                                RPCView.parser_classes)

        WrappedAPIView.authentication_classes = getattr(func, 'authentication_classes',
                                                        RPCView.authentication_classes)

        WrappedAPIView.throttle_classes = getattr(func, 'throttle_classes',
                                                  RPCView.throttle_classes)

        WrappedAPIView.permission_classes = getattr(func, 'permission_classes',
                                                    RPCView.permission_classes)

        # WrappedAPIView.schema = getattr(func, 'schema', RPCView.schema)

        return WrappedAPIView.rpc_bind()

    return decorator
