# -*- coding: utf-8 -*-
from typing import Dict

from rpc_framework.context import RPCViewContext
from rpc_framework.decorators import rpc_view, interceptor_classes
from rpc_framework.interceptors import SessionUserInterceptor


@rpc_view('courier/test_user')
@interceptor_classes([SessionUserInterceptor])
def test_user(context: RPCViewContext) -> Dict:
    return {'user_id': context.user.id}