package com.gmei.data.ctr.sink;

import com.alibaba.fastjson.JSONObject;
import com.gmei.data.ctr.bean.CtrTagCrtBean;
import com.gmei.data.ctr.bean.CtrTagCrtTmpBean;
import com.gmei.data.ctr.common.Constants;
import com.gmei.data.ctr.utils.JDBCUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.sink.RichSinkFunction;

import java.sql.*;

/**
 * @ClassName CtrEstimateTagMysqlSink
 * @Description: CTR特征预估标签MysqlSink
 * @Author zhaojianwei
 * @Date 2020/3/31
 * @Version V1.0
 **/
public class CtrTagCrtMysqlSink extends RichSinkFunction<CtrTagCrtTmpBean> {
    private int maxRetry;
    private long retryInteral;
    private String jdbcUrl;
    private Connection connection;
    public CtrTagCrtMysqlSink(String jdbcUrl, int maxRetry, long retryInteral) {
        this.jdbcUrl = jdbcUrl;
        this.maxRetry = maxRetry;
        this.retryInteral = retryInteral;
    }
    @Override
    public void open(Configuration parameters) throws Exception {
        Class.forName(Constants.MYSQL_DRIVER_CLASS);
        connection = DriverManager.getConnection(jdbcUrl);
        super.open(parameters);
    }
    @Override
    public void invoke(CtrTagCrtTmpBean ctrTagCrtTmpBean, Context context) throws Exception {
        try {
            insertOrUpdate(ctrTagCrtTmpBean);
        }catch (Exception e){
            e.printStackTrace();
            int numReties = 1;
            Exception lastException = e;
            while (numReties <= maxRetry){
                try {
                    numReties++;
                    Thread.sleep(retryInteral);
                    insertOrUpdate(ctrTagCrtTmpBean);
                }catch (Exception e1){
                    lastException = e1;
                    continue;
                }
                return;
            }
            throw lastException;
        }
    }
    @Override
    public void close() throws Exception {
        JDBCUtil.close(connection,null,null);
        super.close();
    }

    /**
     * 数据写入方法
     * @param ctrTagCrtTmpBean
     * @throws SQLException
     */
    private void insertOrUpdate(CtrTagCrtTmpBean ctrTagCrtTmpBean)  {
        CtrTagCrtBean ctrTagCrtBean = null;
        CtrTagCrtBean ctrTagCrtBeanPlat = null;
        if(null != ctrTagCrtTmpBean){
            String deviceId = ctrTagCrtTmpBean.getDeviceId();
            String partitionDate = ctrTagCrtTmpBean.getPartitionDate();
            String type = ctrTagCrtTmpBean.getType();
            String lastUpdateTime = ctrTagCrtTmpBean.getLastUpdateTime();

            String project = ctrTagCrtTmpBean.getProject();
            String firstDemands = ctrTagCrtTmpBean.getFirstDemands();
            String firstPositions = ctrTagCrtTmpBean.getFirstPositions();
            String firstSolutions = ctrTagCrtTmpBean.getFirstSolutions();
            String secondDemands = ctrTagCrtTmpBean.getSecondDemands();
            String secondPositions = ctrTagCrtTmpBean.getSecondPositions();
            String secondSolutions = ctrTagCrtTmpBean.getSecondSolutions();
            if(StringUtils.isNotBlank(type)){
                if("commodity".equals(type) || "content".equals(type)){
                    ctrTagCrtBean = new CtrTagCrtBean();
                    ctrTagCrtBean.setDeviceId(deviceId);
                    ctrTagCrtBean.setPartitionDate(partitionDate);
                    ctrTagCrtBean.setLastUpdateTime(lastUpdateTime);
                    if("commodity".equals(type)){
                        ctrTagCrtBean.setCommodityProject(project);
                        ctrTagCrtBean.setCommodityFirstDemands(firstDemands);
                        ctrTagCrtBean.setCommodityFirstPositions(firstPositions);
                        ctrTagCrtBean.setCommodityFirstSolutions(firstSolutions);
                        ctrTagCrtBean.setCommoditySecondDemands(secondDemands);
                        ctrTagCrtBean.setCommoditySecondPositions(secondPositions);
                        ctrTagCrtBean.setCommoditySecondSolutions(secondSolutions);
                    }else if("content".equals(type)){
                        ctrTagCrtBean.setContentProject(project);
                        ctrTagCrtBean.setContentFirstDemands(firstDemands);
                        ctrTagCrtBean.setContentFirstPositions(firstPositions);
                        ctrTagCrtBean.setContentFirstSolutions(firstSolutions);
                        ctrTagCrtBean.setContentSecondDemands(secondDemands);
                        ctrTagCrtBean.setContentSecondPositions(secondPositions);
                        ctrTagCrtBean.setContentSecondSolutions(secondSolutions);
                    }
                }
                ctrTagCrtBeanPlat = new CtrTagCrtBean();
                ctrTagCrtBeanPlat.setDeviceId(deviceId);
                ctrTagCrtBeanPlat.setPartitionDate(partitionDate);
                ctrTagCrtBeanPlat.setLastUpdateTime(lastUpdateTime);
                ctrTagCrtBeanPlat.setPlatProject(project);
                ctrTagCrtBeanPlat.setPlatFirstDemands(firstDemands);
                ctrTagCrtBeanPlat.setPlatFirstPositions(firstPositions);
                ctrTagCrtBeanPlat.setPlatFirstSolutions(firstSolutions);
                ctrTagCrtBeanPlat.setPlatSecondDemands(secondDemands);
                ctrTagCrtBeanPlat.setPlatSecondPositions(secondPositions);
                ctrTagCrtBeanPlat.setPlatSecondSolutions(secondSolutions);
            }
            insertOrUpdateUnplatInfo(ctrTagCrtBean);
            insertOrUpdatePlatInfo(ctrTagCrtBeanPlat);
        }
    }

    private void insertOrUpdatePlatInfo(CtrTagCrtBean ctrTagCrtBeanPlat){
        boolean isExist = false;
        try{
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(
                    String.format(
                            "select " +
                                    "device_id," +
                                    "plat_project," +
                                    "plat_first_demands," +
                                    "plat_first_positions," +
                                    "plat_first_solutions," +
                                    "plat_second_demands," +
                                    "plat_second_positions," +
                                    "plat_second_solutions," +
                                    "partition_date " +
                            "from device_current_estimate_tag_plat where device_id = '%s' and partition_date = '%s'",
                            ctrTagCrtBeanPlat.getDeviceId(),
                            ctrTagCrtBeanPlat.getPartitionDate()
                    )
            );
            JSONObject platProjectObject = new JSONObject();
            JSONObject platFirstDemandsObject = new JSONObject();
            JSONObject platFirstPositionsObject = new JSONObject();
            JSONObject platFirstSolutionsObject = new JSONObject();
            JSONObject platSecondDemandsObject = new JSONObject();
            JSONObject platSecondPositionsObject = new JSONObject();
            JSONObject platSecondSolutionsObject = new JSONObject();
            if (resultSet.next()){
                isExist = true;
                // 获取平台当天原有字符串信息
                String platProject=resultSet.getString("plat_project");
                String platFirstDemands=resultSet.getString("plat_first_demands");
                String platFirstPositions=resultSet.getString("plat_first_positions");
                String platFirstSolutions=resultSet.getString("plat_first_solutions");
                String platSecondDemands=resultSet.getString("plat_second_demands");
                String platSecondPositions=resultSet.getString("plat_second_positions");
                String platSecondSolutions=resultSet.getString("plat_second_solutions");
                // 获取平台当天原有JSON对象
                platProjectObject = StringUtils.isNotBlank(platProject) ? JSONObject.parseObject(platProject) : new JSONObject();
                platFirstDemandsObject = StringUtils.isNotBlank(platFirstDemands) ? JSONObject.parseObject(platFirstDemands) : new JSONObject();
                platFirstPositionsObject = StringUtils.isNotBlank(platFirstPositions) ? JSONObject.parseObject(platFirstPositions) : new JSONObject();
                platFirstSolutionsObject = StringUtils.isNotBlank(platFirstSolutions) ? JSONObject.parseObject(platFirstSolutions) : new JSONObject();
                platSecondDemandsObject = StringUtils.isNotBlank(platSecondDemands) ? JSONObject.parseObject(platSecondDemands) : new JSONObject();
                platSecondPositionsObject = StringUtils.isNotBlank(platSecondPositions) ? JSONObject.parseObject(platSecondPositions) : new JSONObject();
                platSecondSolutionsObject = StringUtils.isNotBlank(platSecondSolutions) ? JSONObject.parseObject(platSecondSolutions) : new JSONObject();
            }
            String platProject = ctrTagCrtBeanPlat.getPlatProject();
            if(StringUtils.isNotBlank(platProject)){
                String[] splits = platProject.split(",");
                for(String split : splits){
                    if(platProjectObject.keySet().contains(split)){
                        Long aLong = platProjectObject.getLong(split);
                        platProjectObject.put(split,aLong + 1);
                    }else{
                        platProjectObject.put(split,1);
                    }
                }
            }
            String platFirstDemands = ctrTagCrtBeanPlat.getPlatFirstDemands();
            if(StringUtils.isNotBlank(platFirstDemands)){
                String[] splits = platFirstDemands.split(",");
                for (String splict: splits) {
                    if(platFirstDemandsObject.keySet().contains(splict)){
                        Long aLong = platFirstDemandsObject.getLong(splict);
                        platFirstDemandsObject.put(splict,aLong + 1);
                    }else{
                        platFirstDemandsObject.put(splict,1);
                    }
                }
            }
            String platFirstPositions = ctrTagCrtBeanPlat.getPlatFirstPositions();
            if(StringUtils.isNotBlank(platFirstPositions)){
                String[] splits = platFirstPositions.split(",");
                for (String split: splits) {
                    if(platFirstPositionsObject.keySet().contains(split)){
                        Long aLong = platFirstPositionsObject.getLong(split);
                        platFirstPositionsObject.put(split,aLong + 1);
                    }else{
                        platFirstPositionsObject.put(split,1);
                    }
                }
            }
            String platFirstSolutions = ctrTagCrtBeanPlat.getPlatFirstSolutions();
            if(StringUtils.isNotBlank(platFirstSolutions)){
                String[] splits = platFirstSolutions.split(",");
                for (String split: splits) {
                    if(platFirstSolutionsObject.keySet().contains(split)){
                        Long aLong = platFirstSolutionsObject.getLong(split);
                        platFirstSolutionsObject.put(split,aLong + 1);
                    }else{
                        platFirstSolutionsObject.put(split,1);
                    }
                }
            }
            String platSecondDemands = ctrTagCrtBeanPlat.getPlatSecondDemands();
            if(StringUtils.isNotBlank(platSecondDemands)){
                String[] splits = platSecondDemands.split(",");
                for (String split : splits) {
                    if(platSecondDemandsObject.keySet().contains(split)){
                        Long aLong = platSecondDemandsObject.getLong(split);
                        platSecondDemandsObject.put(split,aLong + 1);
                    }else{
                        platSecondDemandsObject.put(split,1);
                    }
                }
            }
            String platSecondPositions = ctrTagCrtBeanPlat.getPlatSecondPositions();
            if(StringUtils.isNotBlank(platSecondPositions)){
                String[] splits = platSecondPositions.split(",");
                for (String split : splits) {
                    if(platSecondPositionsObject.keySet().contains(split)){
                        Long aLong = platSecondPositionsObject.getLong(split);
                        platSecondPositionsObject.put(split,aLong + 1);
                    }else{
                        platSecondPositionsObject.put(split,1);
                    }
                }
            }
            String platSecondSolutions = ctrTagCrtBeanPlat.getPlatSecondSolutions();
            if(StringUtils.isNotBlank(platSecondSolutions)){
                String[] splits = platSecondSolutions.split(",");
                for (String split : splits) {
                    if(platSecondSolutionsObject.keySet().contains(split)){
                        Long aLong = platSecondSolutionsObject.getLong(split);
                        platSecondSolutionsObject.put(split,aLong + 1);
                    }else{
                        platSecondSolutionsObject.put(split,1);
                    }
                }
            }
            if(isExist){
                statement.executeUpdate(
                    String.format(
                        "update device_current_estimate_tag_plat set " +
                                "plat_project = '%s'," +
                                "plat_first_demands = '%s'," +
                                "plat_first_positions = '%s'," +
                                "plat_first_solutions = '%s'," +
                                "plat_second_demands = '%s'," +
                                "plat_second_positions = '%s'," +
                                "plat_second_solutions = '%s'," +
                                "last_update_time = '%s' "
                            + "where device_id = '%s' and partition_date = '%s'",
                            platProjectObject.toJSONString(),
                            platFirstDemandsObject.toJSONString(),
                            platFirstPositionsObject.toJSONString(),
                            platFirstSolutionsObject.toJSONString(),
                            platSecondDemandsObject.toJSONString(),
                            platSecondPositionsObject.toJSONString(),
                            platSecondSolutionsObject.toJSONString(),
                            ctrTagCrtBeanPlat.getLastUpdateTime(),
                            ctrTagCrtBeanPlat.getDeviceId(),
                            ctrTagCrtBeanPlat.getPartitionDate()
                    )
                );
            }else{
                statement.executeUpdate(
                    String.format(
                        "insert into device_current_estimate_tag_plat("+
                                "device_id," +
                                "plat_project," +
                                "plat_first_demands," +
                                "plat_first_positions," +
                                "plat_first_solutions," +
                                "plat_second_demands," +
                                "plat_second_positions," +
                                "plat_second_solutions," +
                                "partition_date," +
                                "last_update_time"
                            + ") values ('%s','%s','%s','%s','%s','%s','%s','%s','%s','%s')",
                        ctrTagCrtBeanPlat.getDeviceId(),
                        platProjectObject.toJSONString(),
                        platFirstDemandsObject.toJSONString(),
                        platFirstPositionsObject.toJSONString(),
                        platFirstSolutionsObject.toJSONString(),
                        platSecondDemandsObject.toJSONString(),
                        platSecondPositionsObject.toJSONString(),
                        platSecondSolutionsObject.toJSONString(),
                        ctrTagCrtBeanPlat.getPartitionDate(),
                        ctrTagCrtBeanPlat.getLastUpdateTime()
                    )
                );
            }
            JDBCUtil.close(null,statement,null);
        }catch (Exception e){
            e.printStackTrace();
        }
    }

    private void insertOrUpdateUnplatInfo(CtrTagCrtBean ctrTagCrtBean){
        boolean isExist = false;
        try{
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(
                    String.format(
                            "select " +
                                "device_id," +
                                "commodity_project," +
                                "commodity_first_demands," +
                                "commodity_first_positions," +
                                "commodity_first_solutions," +
                                "commodity_second_positions," +
                                "commodity_second_solutions," +
                                "commodity_second_demands," +
                                "content_project," +
                                "content_first_demands," +
                                "content_first_positions," +
                                "content_first_solutions," +
                                "content_second_demands," +
                                "content_second_positions," +
                                "content_second_solutions," +
                                "partition_date " +
                            "from device_current_estimate_tag_unplat where device_id = '%s' and partition_date = '%s'",
                            ctrTagCrtBean.getDeviceId(), ctrTagCrtBean.getPartitionDate()));
            JSONObject commodityProjectObject = new JSONObject();
            JSONObject commodityFirstDemandsObject = new JSONObject();
            JSONObject commodityFirstPositionsObject = new JSONObject();
            JSONObject commodityFirstSolutionsObject = new JSONObject();
            JSONObject commoditySecondDemandsObject = new JSONObject();
            JSONObject commoditySecondPositionsObject = new JSONObject();
            JSONObject commoditySecondSolutionsObject = new JSONObject();
            JSONObject contentProjectObject = new JSONObject();
            JSONObject contentFirstDemandsObject = new JSONObject();
            JSONObject contentFirstPositionsObject = new JSONObject();
            JSONObject contentFirstSolutionsObject = new JSONObject();
            JSONObject contentSecondDemandsObject = new JSONObject();
            JSONObject contentSecondPositionsObject = new JSONObject();
            JSONObject contentSecondSolutionsObject = new JSONObject();
            if (resultSet.next()){
                isExist = true;
                // 获取商品当天原有字符串信息
                String commodityProject=resultSet.getString("commodity_project");
                String commodityFirstDemands=resultSet.getString("commodity_first_demands");
                String commodityFirstPositions=resultSet.getString("commodity_first_positions");
                String commodityFirstSolutions=resultSet.getString("commodity_first_solutions");
                String commoditySecondDemands=resultSet.getString("commodity_second_demands");
                String commoditySecondPositions=resultSet.getString("commodity_second_positions");
                String commoditySecondSolutions=resultSet.getString("commodity_second_solutions");
                // 获取内容当天原有字符串信息
                String contentProject=resultSet.getString("content_project");
                String contentFirstDemands=resultSet.getString("content_first_demands");
                String contentFirstPositions=resultSet.getString("content_first_positions");
                String contentFirstSolutions=resultSet.getString("content_first_solutions");
                String contentSecondDemands=resultSet.getString("content_second_demands");
                String contentSecondPositions=resultSet.getString("content_second_positions");
                String contentSecondSolutions=resultSet.getString("content_second_solutions");
                // 获取商品当天原有JSON对象
                commodityProjectObject = StringUtils.isNotBlank(commodityProject) ? JSONObject.parseObject(commodityProject) : new JSONObject();
                commodityFirstDemandsObject = StringUtils.isNotBlank(commodityFirstDemands) ? JSONObject.parseObject(commodityFirstDemands) : new JSONObject();
                commodityFirstPositionsObject = StringUtils.isNotBlank(commodityFirstPositions) ? JSONObject.parseObject(commodityFirstPositions) : new JSONObject();
                commodityFirstSolutionsObject = StringUtils.isNotBlank(commodityFirstSolutions) ? JSONObject.parseObject(commodityFirstSolutions) : new JSONObject();
                commoditySecondDemandsObject = StringUtils.isNotBlank(commoditySecondDemands) ? JSONObject.parseObject(commoditySecondDemands) : new JSONObject();
                commoditySecondPositionsObject = StringUtils.isNotBlank(commoditySecondPositions) ? JSONObject.parseObject(commoditySecondPositions) : new JSONObject();
                commoditySecondSolutionsObject = StringUtils.isNotBlank(commoditySecondSolutions) ? JSONObject.parseObject(commoditySecondSolutions) : new JSONObject();
                // 获取内容当天原有JSON对象
                contentProjectObject = StringUtils.isNotBlank(contentProject) ? JSONObject.parseObject(contentProject) : new JSONObject();
                contentFirstDemandsObject = StringUtils.isNotBlank(contentFirstDemands) ? JSONObject.parseObject(contentFirstDemands) : new JSONObject();
                contentFirstPositionsObject = StringUtils.isNotBlank(contentFirstPositions) ? JSONObject.parseObject(contentFirstPositions) : new JSONObject();
                contentFirstSolutionsObject = StringUtils.isNotBlank(contentFirstSolutions) ? JSONObject.parseObject(contentFirstSolutions) : new JSONObject();
                contentSecondDemandsObject = StringUtils.isNotBlank(contentSecondDemands) ? JSONObject.parseObject(contentSecondDemands) : new JSONObject();
                contentSecondPositionsObject = StringUtils.isNotBlank(contentSecondPositions) ? JSONObject.parseObject(contentSecondPositions) : new JSONObject();
                contentSecondSolutionsObject = StringUtils.isNotBlank(contentSecondSolutions) ? JSONObject.parseObject(contentSecondSolutions) : new JSONObject();
            }
            String commodityProject = ctrTagCrtBean.getCommodityProject();
            if(StringUtils.isNotBlank(commodityProject)){
                String[] splits = commodityProject.split(",");
                for (String split : splits) {
                    if(commodityProjectObject.keySet().contains(split)){
                        Long aLong = commodityProjectObject.getLong(split);
                        commodityProjectObject.put(split,aLong + 1);
                    }else{
                        commodityProjectObject.put(split,1);
                    }
                }
            }
            String commodityFirstDemands = ctrTagCrtBean.getCommodityFirstDemands();
            if(StringUtils.isNotBlank(commodityFirstDemands)){
                String[] splits = commodityFirstDemands.split(",");
                for (String split : splits) {
                    if(commodityFirstDemandsObject.keySet().contains(split)){
                        Long aLong = commodityFirstDemandsObject.getLong(split);
                        commodityFirstDemandsObject.put(split,aLong + 1);
                    }else{
                        commodityFirstDemandsObject.put(split,1);
                    }
                }
            }
            String commodityFirstPositions = ctrTagCrtBean.getCommodityFirstPositions();
            if(StringUtils.isNotBlank(commodityFirstPositions)){
                String[] splits = commodityFirstPositions.split(",");
                for (String split : splits) {
                    if(commodityFirstPositionsObject.keySet().contains(split)){
                        Long aLong = commodityFirstPositionsObject.getLong(split);
                        commodityFirstPositionsObject.put(split,aLong + 1);
                    }else{
                        commodityFirstPositionsObject.put(split,1);
                    }
                }
            }
            String commodityFirstSolutions = ctrTagCrtBean.getCommodityFirstSolutions();
            if(StringUtils.isNotBlank(commodityFirstSolutions)){
                String[] splits = commodityFirstSolutions.split(",");
                for (String split : splits) {
                    if(commodityFirstSolutionsObject.keySet().contains(split)){
                        Long aLong = commodityFirstSolutionsObject.getLong(split);
                        commodityFirstSolutionsObject.put(split,aLong + 1);
                    }else{
                        commodityFirstSolutionsObject.put(split,1);
                    }
                }
            }
            String commoditySecondDemands = ctrTagCrtBean.getCommoditySecondDemands();
            if(StringUtils.isNotBlank(commoditySecondDemands)){
                String[] splits = commoditySecondDemands.split(",");
                for (String split : splits) {
                    if(commoditySecondDemandsObject.keySet().contains(split)){
                        Long aLong = commoditySecondDemandsObject.getLong(split);
                        commoditySecondDemandsObject.put(split,aLong + 1);
                    }else{
                        commodityFirstSolutionsObject.put(split,1);
                    }
                }
            }
            String commoditySecondPositions = ctrTagCrtBean.getCommoditySecondPositions();
            if(StringUtils.isNotBlank(commoditySecondPositions)){
                String[] splits = commoditySecondPositions.split(",");
                for (String split : splits) {
                    if(commoditySecondPositionsObject.keySet().contains(split)){
                        Long aLong = commoditySecondPositionsObject.getLong(split);
                        commoditySecondPositionsObject.put(split,aLong + 1);
                    }else{
                        commoditySecondPositionsObject.put(split,1);
                    }
                }
            }
            String commoditySecondSolutions = ctrTagCrtBean.getCommoditySecondSolutions();
            if(StringUtils.isNotBlank(commoditySecondSolutions)){
                String[] splits = commoditySecondSolutions.split(",");
                for (String split : splits) {
                    if(commoditySecondSolutionsObject.keySet().contains(split)){
                        Long aLong = commoditySecondSolutionsObject.getLong(split);
                        commoditySecondSolutionsObject.put(split,aLong + 1);
                    }else{
                        commoditySecondSolutionsObject.put(split,1);
                    }
                }
            }
            String contentProject = ctrTagCrtBean.getContentProject();
            if(StringUtils.isNotBlank(contentProject)){
                String[] splits = contentProject.split(",");
                for (String split :splits ) {
                    if(contentProjectObject.keySet().contains(split)){
                        Long aLong = contentProjectObject.getLong(split);
                        contentProjectObject.put(split,aLong + 1);
                    }else{
                        contentProjectObject.put(split,1);
                    }
                }
            }
            String contentFirstDemands = ctrTagCrtBean.getContentFirstDemands();
            if(StringUtils.isNotBlank(contentFirstDemands)){
                String[] splits = contentFirstDemands.split(",");
                for (String split : splits) {
                    if(contentFirstDemandsObject.keySet().contains(split)){
                        Long aLong = contentFirstDemandsObject.getLong(split);
                        contentFirstDemandsObject.put(split,aLong + 1);
                    }else{
                        contentFirstDemandsObject.put(split,1);
                    }
                }
            }
            String contentFirstPositions = ctrTagCrtBean.getContentFirstPositions();
            if(StringUtils.isNotBlank(contentFirstPositions)){
                String[] splits = contentFirstPositions.split(",");
                for (String split : splits) {
                    if(contentFirstPositionsObject.keySet().contains(split)){
                        Long aLong = contentFirstPositionsObject.getLong(split);
                        contentFirstPositionsObject.put(split,aLong + 1);
                    }else{
                        contentFirstPositionsObject.put(split,1);
                    }
                }
            }
            String contentFirstSolutions = ctrTagCrtBean.getContentFirstSolutions();
            if(StringUtils.isNotBlank(contentFirstSolutions)){
                String[] splits = contentFirstSolutions.split(",");
                for (String split : splits) {
                    if(contentFirstSolutionsObject.keySet().contains(split)){
                        Long aLong = contentFirstSolutionsObject.getLong(split);
                        contentFirstSolutionsObject.put(split,aLong + 1);
                    }else{
                        contentFirstSolutionsObject.put(split,1);
                    }
                }
            }
            String contentSecondDemands = ctrTagCrtBean.getContentSecondDemands();
            if(StringUtils.isNotBlank(contentSecondDemands)){
                String[] splits = contentSecondDemands.split(",");
                for (String split : splits) {
                    if(contentSecondDemandsObject.keySet().contains(split)){
                        Long aLong = contentSecondDemandsObject.getLong(split);
                        contentSecondDemandsObject.put(split,aLong + 1);
                    }else{
                        contentSecondDemandsObject.put(split,1);
                    }
                }
            }
            String contentSecondPositions = ctrTagCrtBean.getContentSecondPositions();
            if(StringUtils.isNotBlank(contentSecondPositions)){
                String[] splits = contentSecondPositions.split(",");
                for (String split : splits) {
                    if(contentSecondPositionsObject.keySet().contains(split)){
                        Long aLong = contentSecondPositionsObject.getLong(split);
                        contentSecondPositionsObject.put(split,aLong + 1);
                    }else{
                        contentSecondPositionsObject.put(split,1);
                    }
                }
            }
            String contentSecondSolutions = ctrTagCrtBean.getContentSecondSolutions();
            if(StringUtils.isNotBlank(contentSecondSolutions)){
                String[] splits = contentSecondSolutions.split(",");
                for (String split : splits) {
                    if(contentSecondSolutionsObject.keySet().contains(split)){
                        Long aLong = contentSecondSolutionsObject.getLong(split);
                        contentSecondSolutionsObject.put(split,aLong + 1);
                    }else{
                        contentSecondSolutionsObject.put(split,1);
                    }
                }
            }
            if(isExist){
                statement.executeUpdate(
                        String.format(
                                "update device_current_estimate_tag_unplat set " +
                                        "commodity_project = '%s'," +
                                        "commodity_first_demands = '%s'," +
                                        "commodity_first_positions = '%s'," +
                                        "commodity_first_solutions = '%s'," +
                                        "commodity_second_demands = '%s'," +
                                        "commodity_second_positions = '%s'," +
                                        "commodity_second_solutions = '%s'," +
                                        "content_project = '%s'," +
                                        "content_first_demands = '%s'," +
                                        "content_first_positions = '%s'," +
                                        "content_first_solutions = '%s'," +
                                        "content_second_demands = '%s'," +
                                        "content_second_positions = '%s'," +
                                        "content_second_solutions = '%s'," +
                                        "last_update_time = '%s' " +
                                        "where device_id = '%s' and partition_date = '%s'",
                                commodityProjectObject.toJSONString(),
                                commodityFirstDemandsObject.toJSONString(),
                                commodityFirstPositionsObject.toJSONString(),
                                commodityFirstSolutionsObject.toJSONString(),
                                commoditySecondDemandsObject.toJSONString(),
                                commoditySecondPositionsObject.toJSONString(),
                                commoditySecondSolutionsObject.toJSONString(),
                                contentProjectObject.toJSONString(),
                                contentFirstDemandsObject.toJSONString(),
                                contentFirstPositionsObject.toJSONString(),
                                contentFirstSolutionsObject.toJSONString(),
                                contentSecondDemandsObject.toJSONString(),
                                contentSecondPositionsObject.toJSONString(),
                                contentSecondSolutionsObject.toJSONString(),
                                ctrTagCrtBean.getLastUpdateTime(),
                                ctrTagCrtBean.getDeviceId(),
                                ctrTagCrtBean.getPartitionDate()
                        )
                );
            }else{
                statement.executeUpdate(
                        String.format(
                                "insert into device_current_estimate_tag_unplat(" +
                                        "device_id," +
                                        "commodity_project," +
                                        "commodity_first_demands," +
                                        "commodity_first_positions," +
                                        "commodity_first_solutions," +
                                        "commodity_second_positions," +
                                        "commodity_second_solutions," +
                                        "commodity_second_demands," +
                                        "content_project," +
                                        "content_first_demands," +
                                        "content_first_positions," +
                                        "content_first_solutions," +
                                        "content_second_demands," +
                                        "content_second_positions," +
                                        "content_second_solutions," +
                                        "partition_date," +
                                        "last_update_time" +
                                        ") values ('%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s')",
                                ctrTagCrtBean.getDeviceId(),
                                commodityProjectObject.toJSONString(),
                                commodityFirstDemandsObject.toJSONString(),
                                commodityFirstPositionsObject.toJSONString(),
                                commodityFirstSolutionsObject.toJSONString(),
                                commoditySecondDemandsObject.toJSONString(),
                                commoditySecondPositionsObject.toJSONString(),
                                commoditySecondSolutionsObject.toJSONString(),
                                contentProjectObject.toJSONString(),
                                contentFirstDemandsObject.toJSONString(),
                                contentFirstPositionsObject.toJSONString(),
                                contentFirstSolutionsObject.toJSONString(),
                                contentSecondDemandsObject.toJSONString(),
                                contentSecondPositionsObject.toJSONString(),
                                contentSecondSolutionsObject.toJSONString(),
                                ctrTagCrtBean.getPartitionDate(),
                                ctrTagCrtBean.getLastUpdateTime()
                        )
                );
                JDBCUtil.close(null,statement,null);
            }
        }catch (Exception e){
            e.printStackTrace();
        }
    }
}
