package com.gmei.data.ctr.source;

import com.alibaba.druid.pool.DruidDataSource;
import com.gmei.data.ctr.bean.CtrPfrRctBean;
import com.gmei.data.ctr.bean.CtrPfrRctEtlBean;
import com.gmei.data.ctr.common.Constants;
import com.gmei.data.ctr.utils.DateUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.async.ResultFuture;
import org.apache.flink.streaming.api.functions.async.RichAsyncFunction;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Collections;
import java.util.Date;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.Supplier;

import static java.util.concurrent.Executors.newFixedThreadPool;

/**
 * @ClassName MysqlAsyncSource
 * @Author apple
 * @Date 2020/3/29
 * @Version V1.0
 **/
public class JrAsyncPfrRctSource extends RichAsyncFunction<CtrPfrRctEtlBean, CtrPfrRctBean> {
    private String jerryJdbcUrl;
    private String jerryUsername;
    private String jerryPassword;
    private transient DruidDataSource dataSource;
    private transient ExecutorService executorService;

    public JrAsyncPfrRctSource(String jerryJdbcUrl, String jerryUsername, String jerryPassword) {
        this.jerryJdbcUrl = jerryJdbcUrl;
        this.jerryUsername = jerryUsername;
        this.jerryPassword = jerryPassword;
    }
    @Override
    public void open(Configuration parameters) throws Exception {
        super.open(parameters);
        executorService = newFixedThreadPool(20);
        dataSource = new DruidDataSource();
        dataSource.setDriverClassName(Constants.MYSQL_DRIVER_CLASS);
        dataSource.setUrl(jerryJdbcUrl);
        dataSource.setUsername(jerryUsername);
        dataSource.setPassword(jerryPassword);
        dataSource.setInitialSize(5);
        dataSource.setMinIdle(10);
        dataSource.setMaxActive(20);
    }
    @Override
    public void asyncInvoke(CtrPfrRctEtlBean ctrPfrRctEtlBean, ResultFuture<CtrPfrRctBean> resultFuture) throws Exception {
        Future<CtrPfrRctBean> future = executorService.submit(() -> {
            return queryFromMySql(ctrPfrRctEtlBean);
        });
        CompletableFuture.supplyAsync(new Supplier<CtrPfrRctBean>() {
            @Override
            public CtrPfrRctBean get() {
                try {
                    return future.get();
                } catch (Exception e) {
                    return null;
                }
            }
        }).thenAccept((CtrPfrRctBean dbResult) ->{
            resultFuture.complete(Collections.singleton(dbResult));
        });
    }
    @Override
    public void close() {
        if(dataSource != null){
            dataSource.close();
        }
        if(executorService != null){
            executorService.shutdown();
        }
    }

    private CtrPfrRctBean queryFromMySql(CtrPfrRctEtlBean ctrPfrRctEtlBean)  {
        CtrPfrRctBean dcept = null;
        String statisticsType = ctrPfrRctEtlBean.getStatisticsType();
        String deviceId = ctrPfrRctEtlBean.getDeviceId();
        String statisticsTypeId = ctrPfrRctEtlBean.getStatisticsTypeId();
        if(statisticsType != null && deviceId!= null && statisticsTypeId != null){
            String sql = "";
            if("service".equals(statisticsType)){
                sql = String.format("select first_demands,first_positions,first_solutions,second_demands,second_positions,second_solutions,project_tags " +
                        "from strategy_service_tagv3_info where service_id = '%s'",statisticsTypeId);
            }else if("diary".equals(statisticsType)){
                sql = String.format("select first_demands,first_positions,first_solutions,second_demands,second_positions,second_solutions,project_tags " +
                        "from strategy_content_tagv3_info where content_id = '%s'",statisticsTypeId);
            }else if("tractate".equals(statisticsType)){
                sql = String.format("select first_demands,first_positions,first_solutions,second_demands,second_positions,second_solutions,project_tags " +
                        "from strategy_tractate_tagv3_info where content_id = '%s'",statisticsTypeId);
            }else if("answer".equals(statisticsType)){
                sql = String.format("select first_demands,first_positions,first_solutions,second_demands,second_positions,second_solutions,project_tags " +
                        "from strategy_answer_tagv3_info where content_id = '%s'",statisticsTypeId);
            }
            if(StringUtils.isNotBlank(sql)){
                dcept = findTagInfo(sql, ctrPfrRctEtlBean);
                if(null != dcept){
                    Date date = new Date();
                    dcept.setDeviceId(deviceId);
                    dcept.setStatisticsType(statisticsType);
                    dcept.setStatisticsTypeId(statisticsTypeId);
                    dcept.setLastUpdateTime(DateUtil.getTimeStr(date));
                }
            }
        }
        return dcept;
    }

    private CtrPfrRctBean findTagInfo(String sql, CtrPfrRctEtlBean ctrPfrRctEtlBean){
        CtrPfrRctBean ctrPfrRctBean = null;
        Connection connection = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            connection = dataSource.getConnection();
            stmt = connection.prepareStatement(sql);
            rs = stmt.executeQuery();
            while(rs.next()){
                ctrPfrRctBean = new CtrPfrRctBean();
                ctrPfrRctBean.setProjectPfr(rs.getString("project_tags"));
                ctrPfrRctBean.setFirstDemandsPfr(rs.getString("first_demands"));
                ctrPfrRctBean.setFirstPositionsPfr(rs.getString("first_positions"));
                ctrPfrRctBean.setFirstSolutionsPfr(rs.getString("first_solutions"));
                ctrPfrRctBean.setSecondDemandsPfr(rs.getString("second_demands"));
                ctrPfrRctBean.setSecondPositionsPfr(rs.getString("second_positions"));
                ctrPfrRctBean.setSecondSolutionsPfr(rs.getString("second_solutions"));
            }
        } catch (Exception e){
            e.printStackTrace();
        }finally {
            try{
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }catch (Exception e){
                e.printStackTrace();
            }
        }
        return ctrPfrRctBean;
    }
}