package com.gmei.data.ctr.utils;

import com.alibaba.fastjson.JSONArray;
import com.gmei.data.ctr.bean.PfrRecentInfo;
import org.apache.commons.lang3.StringUtils;

import java.util.*;

/**
 * @ClassName StringUtil
 * @Author apple
 * @Date 2020/4/13
 * @Version V1.0
 **/
public class StringUtil {

    public static Map<String,Integer> transPairedString2Map(String str){
        Map<String,Integer> map = new HashMap<String,Integer>();
        String[] splits = str.split(",");
        for (String split: splits) {
            String[] sp = split.split(":");
            if(sp.length == 2){
                map.put(sp[0],Integer.valueOf(sp[1]));
            }
        }
        return map;
    }

    public static String transMap2PairedString(Map<String,Integer> map){
        String str = "";
        for (Map.Entry entry: map.entrySet()) {
            str += entry.getKey() + ":" + entry.getValue() + ",";
        }
        if(str.length() == 0){
            return str;
        }
        return str.substring(0,str.length() -1);
    }

    public static Map<String,Integer> transString2Map(String str){
        Map<String,Integer> map = new HashMap<String,Integer>();
        String[] splits = str.split(",");
        for (String split : splits) {
            if(StringUtils.isNotBlank(split)){
                map.put(split,1);
            }
        }
        return map;
    }

    public static LinkedList<PfrRecentInfo> transString2PfrRecentInfoList(String str,String timeStr){
        LinkedList<PfrRecentInfo> pfrRecentInfoList = new LinkedList<>();
        String[] splits = str.split(",");
        for (String split : splits) {
            if(StringUtils.isNotBlank(split)){
                pfrRecentInfoList.add(new PfrRecentInfo(split,1,timeStr));
            }
        }
        return pfrRecentInfoList;
    }

    public static String transPfrRecentInfoList2String(LinkedList<PfrRecentInfo> list){
        String str = "";
        for (PfrRecentInfo pfrRecentInfo: list) {
            str += pfrRecentInfo.getPfrName() + ":" + pfrRecentInfo.getPfrCount() + ",";
        }
        if(str.length() == 0){
            return str;
        }
        return str.substring(0,str.length() -1);
    }

    public static String transPfrRecentInfoList2SplitedPairedString(LinkedList<PfrRecentInfo> list){
        LinkedList<PfrRecentInfo> newList = new LinkedList<>();
        for (PfrRecentInfo pfrRecentInfo: list) {
            String pfrName = pfrRecentInfo.getPfrName();
            if(pfrName.contains(",")){
                String[] splits = pfrName.split(",");
                for(String split : splits){
                    newList.add(new PfrRecentInfo(split,1));
                }
            }else{
                newList.add(new PfrRecentInfo(pfrName,1));
            }
        }

        Map<String,Integer> map = new HashMap<>();
        for (PfrRecentInfo pfrRecentInfo: newList) {
            String pfrName = pfrRecentInfo.getPfrName();
            if(map.keySet().contains(pfrRecentInfo.getPfrName())){
                Integer rs = map.get(pfrName);
                map.put(pfrName,pfrRecentInfo.getPfrCount() + rs);
            }else{
                map.put(pfrName,pfrRecentInfo.getPfrCount());
            }
        }
        return transMap2PairedString(map);
    }



    public static Map<String,Integer> increaseByKey(Map<String,Integer> oldMap,String str){
        Map<String, Integer> stringIntegerMap = transString2Map(str);
        for(Map.Entry<String,Integer> entry : oldMap.entrySet()){
            String key = entry.getKey();
            if(stringIntegerMap.containsKey(key)){
                Integer value = oldMap.get(key);
                Integer result = value + 1;
                oldMap.put(key,result);
            }
            stringIntegerMap.remove(key);
        }
        oldMap.putAll(stringIntegerMap);
        return oldMap;
    }

    public static String transString2PairedString(String str){
        Map<String, Integer> stringIntegerMap = transString2Map(str);
        return transMap2PairedString(stringIntegerMap);
    }

    public static String increasePfr(String oldStr,String str) {
        Map<String,Integer> oldMap = transPairedString2Map(oldStr);
        Map<String, Integer> newMap = increaseByKey(oldMap,str);
        return transMap2PairedString(newMap);
    }

    public static void main(String[] args) {
//      String str = "xx:1,yy:2,zz:3";
//      String newPfr = "xx,yy,zz";
//      String s = increasePfr(str, newPfr);
//      System.out.println(s);
//      System.out.println(transString2PairedString(newPfr));
//
//      JSONArray ja = new JSONArray();
//
//        LinkedList<String> list = new LinkedList<String>();
//        list.add("c");
//        list.add("b");
//        list.add("d");
//        list.add("a");
//        Collections.sort(list);
//        list.removeLast();
//        for (String ss: list) {
//            System.out.println(ss);
//        }
        LinkedList<PfrRecentInfo> list = new LinkedList<>();
        list.add(new PfrRecentInfo("xx,yy",1));
        list.add(new PfrRecentInfo("xx",1));
        list.add(new PfrRecentInfo("yy",1));
        list.add(new PfrRecentInfo("yy",1));
        String rs = transPfrRecentInfoList2SplitedPairedString(list);
        System.out.println(rs);
    }
}
