package com.gmei.data.ctr.main;

import com.gmei.data.ctr.operator.CtrEstimateTagOperator;
import com.gmei.data.ctr.source.MaidianKafkaSource;
import org.apache.flink.api.java.utils.ParameterTool;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;

/**
 * @ClassName TestCtrEstimateMainTag
 * @Description: CTR预估特征实时处理入口
 * @Author apple
 * @Date 2020/3/30
 * @Version V1.0
 **/
public class TestCtrEstimateMainTag {

    public static void main(String[] args) throws Exception{
        // 获取运行参数
        ParameterTool parameterTool = ParameterTool.fromArgs(args);
        String inBrokers = parameterTool.get("inBrokers","172.16.44.25:9092,172.16.44.31:9092,172.16.44.45:9092");
        String batchSize = parameterTool.get("batchSize","1000");
        String maidianInTopic = parameterTool.get("maidianInTopic", "gm-maidian-data");
        String maidianInGroupId = parameterTool.get("maidianInGroupId","test-ctr-estimate-tag");
        Integer windowSize = parameterTool.getInt("windowSize",5);
        Integer slideSize = parameterTool.getInt("slideSize",5);
        String outJdbcUrl = parameterTool.get("outJdbcUrl",
                "jdbc:mysql://172.18.44.3:3306/jerry_test?user=root&password=5OqYM^zLwotJ3oSo&autoReconnect=true&useSSL=false");
        Integer maxRetry = parameterTool.getInt("maxRetry",3);
        Long retryInteral = parameterTool.getLong("retryInteral",3000);
        String checkpointPath = parameterTool.get("checkpointPath","hdfs://bj-gmei-hdfs/user/data/flink/ctr-estimate-tag/checkpoint");
        Boolean isStartFromEarliest = parameterTool.getBoolean("isStartFromEarliest",true);
        Boolean isStartFromLatest = parameterTool.getBoolean("isStartFromLatest",false);
        String startTime = parameterTool.get("startTime","2020-04-04 20:42:00");
        Integer parallelism = parameterTool.getInt("parallelism",2);
        String inZxJdbcUrl = parameterTool.get("inZxJdbcUrl","jdbc:mysql://172.16.30.141:3306/zhengxing?characterEncoding=UTF-8&autoReconnect=true&useSSL=false");
        String inZxUsername = parameterTool.get("inZxUsername","work");
        String inZxPassword = parameterTool.get("inZxPassword","BJQaT9VzDcuPBqkd");
        String inJerryJdbcUrl = parameterTool.get("inJerryJdbcUrl","jdbc:mysql://172.16.40.170:4000/jerry_test?characterEncoding=UTF-8&autoReconnect=true&useSSL=false");
        String inJerryUsername = parameterTool.get("inJerryUsername","data_user");
        String inJerryPassword = parameterTool.get("inJerryPassword","YPEzp78HQBuhByWPpefQu6X3D6hEPfD6");

        // 核心参数打印
        System.out.println("**********************************************************");
        System.out.println("*** inBrokers: " + inBrokers);
        System.out.println("*** maidianInTopic: "+ maidianInTopic);
        System.out.println("*** maidianInGroupId: " + maidianInGroupId);
        System.out.println("*** outJdbcUrl: " + outJdbcUrl);
        System.out.println("*** checkpointPath: " + checkpointPath);
        System.out.println("*** startTime: " + startTime);
        System.out.println("*** windowSize: " + windowSize);
        System.out.println("*** slideSize: " + slideSize);
        System.out.println("*** inZxJdbcUrl: " + inZxJdbcUrl);
        System.out.println("*** inZxUsername: " + inZxUsername);
        System.out.println("*** inZxPassword: " + inZxPassword);
        System.out.println("*** inJerryJdbcUrl: " + inJerryJdbcUrl);
        System.out.println("*** inJerryUsername: " + inJerryUsername);
        System.out.println("*** inJerryPassword: " + inJerryPassword);
        System.out.println("**********************************************************");

        // 获得流处理环境对象
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        //env.setStreamTimeCharacteristic(TimeCharacteristic.EventTime);

        DataStream MaidianDataStream = new MaidianKafkaSource(
                env,
                inBrokers,
                maidianInTopic,
                maidianInGroupId,
                batchSize,
                isStartFromEarliest,
                isStartFromLatest,
                startTime
        ).getInstance();

        // 执行处理核心逻辑
        new CtrEstimateTagOperator(
                MaidianDataStream,
                outJdbcUrl,
                maxRetry,
                retryInteral,
                parallelism,
                windowSize,
                slideSize,
                inZxJdbcUrl,
                inZxUsername,
                inZxPassword,
                inJerryJdbcUrl,
                inJerryUsername,
                inJerryPassword
        ).run();

        // 常驻执行
        env.execute("ctr-estimate-tag");
    }
}
