package com.gmei.data.ctr.source;

import com.gmei.data.ctr.utils.DateUtils;
import org.apache.flink.api.common.serialization.SimpleStringSchema;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.kafka.clients.consumer.ConsumerConfig;

import java.text.ParseException;

/**
 * @ClassName MaidianKafkaSource
 * @Description: 埋点日志kafka数据源
 * @Author zhaojianwei
 * @Date 2020/3/31
 * @Version V1.0
 **/
public class MaidianKafkaSource implements BaseSource{
    private StreamExecutionEnvironment env;
    private String inBrokers;
    private String maidianInTopic;
    private String groupId;
    private String batchSize;
    private Boolean isStartFromEarliest;
    private Boolean isStartFromLatest;
    private String startTime;

    public MaidianKafkaSource(StreamExecutionEnvironment env, String inBrokers, String maidianInTopic, String groupId,
                              String batchSize, Boolean isStartFromEarliest, Boolean isStartFromLatest, String startTime) {
        this.env = env;
        this.inBrokers = inBrokers;
        this.maidianInTopic = maidianInTopic;
        this.groupId = groupId;
        this.batchSize = batchSize;
        this.isStartFromEarliest = isStartFromEarliest;
        this.isStartFromLatest = isStartFromLatest;
        this.startTime = startTime;
    }

    @Override
    public DataStream getInstance() throws ParseException {
        // 获得埋点日志数据
        GmeiKafkaSource maidianKafkaSource = new GmeiKafkaSource(maidianInTopic);
        maidianKafkaSource.setSource(new SimpleStringSchema());
        maidianKafkaSource.setProp(ConsumerConfig.BOOTSTRAP_SERVERS_CONFIG,inBrokers);
        maidianKafkaSource.setProp(ConsumerConfig.GROUP_ID_CONFIG,groupId);
        maidianKafkaSource.setProp(ConsumerConfig.MAX_POLL_RECORDS_CONFIG,batchSize);
        if(isStartFromEarliest){
            maidianKafkaSource.getSource().setStartFromEarliest();
        }else if(isStartFromLatest != null){
            maidianKafkaSource.getSource().setStartFromLatest();
        }else if(startTime != null){
            maidianKafkaSource.getSource().setStartFromTimestamp(DateUtils.getTimestampByDateStr(startTime));
        }
        DataStreamSource maidianLogDatas = env.addSource(maidianKafkaSource.getSource());
        return maidianLogDatas;
    }
}
