#!/bin/bash

# */5 * * * * /srv/apps/ctr-estimate/bin/auto.sh >> /data/log/ctr-estimate/auto.out

task_names=(ctr-estimate-clk-crt ctr-estimate-pfr-crt ctr-estimate-pfr-rct ctr-estimate-tag-crt a)
for element in "${task_names[@]}"
  do
    app_id=`/opt/hadoop-2.6.0-cdh5.16.1/bin/yarn application -list | grep -w $element | awk '{print $1}'`
    if [[ -z $app_id ]];then
      if [ "ctr-estimate-clk-crt" == "$element" ];then
        nohup /srv/apps/ctr-estimate/bin/start_clk_crt.sh 2>&1 & >/dev/null
        echo `date +"%Y-%m-%d %H:%M:%S"`": restart task "$element" ..."
      elif [ "ctr-estimate-pfr-crt" == "$element" ]; then
        nohup /srv/apps/ctr-estimate/bin/start_pfr_crt.sh 2>&1 & >/dev/null
        echo `date +"%Y-%m-%d %H:%M:%S"`": restart task "$element" ..."
      elif [ "ctr-estimate-pfr-rct" == "$element" ]; then
        nohup /srv/apps/ctr-estimate/bin/start_pfr_rct.sh 2>&1 & >/dev/null
        echo `date +"%Y-%m-%d %H:%M:%S"`": restart task "$element" ..."
      elif [ "ctr-estimate-tag-crt" == "$element" ]; then
        nohup /srv/apps/ctr-estimate/bin/start_tag_crt.sh 2>&1 & >/dev/null
        echo `date +"%Y-%m-%d %H:%M:%S"`": restart task "$element" ..."
      else
        echo $element" is not a valid task name, please check it again!"
      fi
    else
      echo `date +"%Y-%m-%d %H:%M:%S"`": task "$element" is running ..."
    fi
  done