package com.gmei.data.ctr.sink;

import com.gmei.data.ctr.bean.CtrClkCrtBean;
import com.gmei.data.ctr.common.Constants;
import com.gmei.data.ctr.utils.DateUtil;
import com.gmei.data.ctr.utils.JDBCUtil;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.sink.RichSinkFunction;

import java.sql.*;
import java.util.Date;


/**
 * @ClassName CtrEstimateClkMysqlSink
 * @Description: CTR特征预估点击量MysqlSink
 * @Author zhaojianwei
 * @Date 2020/3/31
 * @Version V1.0
 **/
public class CtrClkCrtMysqlSink extends RichSinkFunction<CtrClkCrtBean> {
    private String jdbcUrl;
    private int maxRetry;
    private long retryInteral;
    private Connection connection;
    public CtrClkCrtMysqlSink(String jdbcUrl, int maxRetry, long retryInteral) {
        this.jdbcUrl = jdbcUrl;
        this.maxRetry = maxRetry;
        this.retryInteral = retryInteral;
    }
    @Override
    public void open(Configuration parameters) throws Exception {
        Class.forName(Constants.MYSQL_DRIVER_CLASS);
        connection = DriverManager.getConnection(jdbcUrl);
        super.open(parameters);
    }
    @Override
    public void invoke(CtrClkCrtBean ctrClkCrtBean, Context context) throws Exception {
        try {
            insertOrUpdate(ctrClkCrtBean);
        }catch (Exception e){
            e.printStackTrace();
            int numReties = 1;
            Exception lastException = e;
            while (numReties <= maxRetry){
                try {
                    numReties++;
                    Thread.sleep(retryInteral);
                    insertOrUpdate(ctrClkCrtBean);
                }catch (Exception e1){
                    lastException = e1;
                    continue;
                }
                return;
            }
            throw lastException;
        }
    }
    @Override
    public void close() throws Exception {
        JDBCUtil.close(connection,null,null);
        super.close();
    }

    /**
     * 数据写入方法
     * @param ctrClkCrtBean
     * @throws SQLException
     */
    private void insertOrUpdate(CtrClkCrtBean ctrClkCrtBean) throws SQLException {
        if(null != ctrClkCrtBean){
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(String.format("select device_id,content_card_click,tractate_card_click,answer_card_click,partition_date " +
                            "from device_current_estimate_clk where device_id = '%s' and partition_date = '%s'"
                    , ctrClkCrtBean.getDeviceId()
                    , ctrClkCrtBean.getPartitionDate())
            );
            CtrClkCrtBean newCtrClkCrtBean = null;
            if (resultSet.next()){
                newCtrClkCrtBean = new CtrClkCrtBean();
                newCtrClkCrtBean.setDeviceId(resultSet.getString("device_id"));
                newCtrClkCrtBean.setAnswerCardClick(resultSet.getLong("answer_card_click") + ctrClkCrtBean.getAnswerCardClick());
                newCtrClkCrtBean.setContentCardClick(resultSet.getLong("content_card_click") + ctrClkCrtBean.getContentCardClick());
                newCtrClkCrtBean.setTractateCardClick(resultSet.getLong("tractate_card_click") + ctrClkCrtBean.getTractateCardClick());
                newCtrClkCrtBean.setPartitionDate(resultSet.getString("partition_date"));
            }
            if(null != newCtrClkCrtBean){
                statement.executeUpdate(String.format("update device_current_estimate_clk set " +
                                "content_card_click = %d," +
                                "tractate_card_click = %d, " +
                                "answer_card_click = %d," +
                                "last_update_time = '%s'" +
                                "where device_id = '%s' and partition_date = '%s'",
                        newCtrClkCrtBean.getAnswerCardClick(),
                        newCtrClkCrtBean.getContentCardClick(),
                        newCtrClkCrtBean.getTractateCardClick(),
                        DateUtil.getTimeStr(new Date()),
                        newCtrClkCrtBean.getDeviceId(),
                        newCtrClkCrtBean.getPartitionDate()
                    )
                );
            }else{
                statement.executeUpdate(String.format("insert into device_current_estimate_clk(" +
                                "device_id," +
                                "answer_card_click," +
                                "content_card_click," +
                                "tractate_card_click," +
                                "partition_date," +
                                "last_update_time" +
                                ") values('%s',%d,%d,%d,'%s','%s')",
                        ctrClkCrtBean.getDeviceId(),
                        ctrClkCrtBean.getAnswerCardClick(),
                        ctrClkCrtBean.getContentCardClick(),
                        ctrClkCrtBean.getTractateCardClick(),
                        ctrClkCrtBean.getPartitionDate(),
                        ctrClkCrtBean.getLastUpdateTime())
                );
            }
            JDBCUtil.close(null,statement,null);
        }
    }
}
