package com.gmei.data.ctr.source;

import com.alibaba.druid.pool.DruidDataSource;
import com.gmei.data.ctr.bean.CtrEstimateTagEtl;
import com.gmei.data.ctr.bean.DeviceCurrentEstimateTagTmp;
import com.gmei.data.ctr.utils.DateUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.async.ResultFuture;
import org.apache.flink.streaming.api.functions.async.RichAsyncFunction;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Collections;
import java.util.Date;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.Supplier;

import static java.util.concurrent.Executors.newFixedThreadPool;

/**
 * @ClassName MysqlAsyncSource
 * @Author apple
 * @Date 2020/3/29
 * @Version V1.0
 **/
public class ZhengxingMysqlAsyncSource extends RichAsyncFunction<CtrEstimateTagEtl, DeviceCurrentEstimateTagTmp> {
    private transient DruidDataSource dataSource;
    private transient ExecutorService executorService;

    @Override
    public void open(Configuration parameters) throws Exception {
        super.open(parameters);
        executorService = newFixedThreadPool(20);
        dataSource = new DruidDataSource();
        dataSource.setDriverClassName("com.mysql.jdbc.Driver");
        dataSource.setUsername("work");
        dataSource.setPassword("BJQaT9VzDcuPBqkd");
        dataSource.setUrl("jdbc:mysql://172.16.30.141:3306/zhengxing?characterEncoding=UTF-8&autoReconnect=true&useSSL=false");
        dataSource.setInitialSize(5);
        dataSource.setMinIdle(10);
        dataSource.setMaxActive(20);
    }
    @Override
    public void asyncInvoke(CtrEstimateTagEtl ctrEstimateTagEtl, ResultFuture<DeviceCurrentEstimateTagTmp> resultFuture) throws Exception {
        Future<DeviceCurrentEstimateTagTmp> future = executorService.submit(() -> {
            return queryFromMySql(ctrEstimateTagEtl);
        });
        CompletableFuture.supplyAsync(new Supplier<DeviceCurrentEstimateTagTmp>() {
            @Override
            public DeviceCurrentEstimateTagTmp get() {
                try {
                    return future.get();
                } catch (Exception e) {
                    return null;
                }
            }
        }).thenAccept((DeviceCurrentEstimateTagTmp dbResult) ->{
            resultFuture.complete(Collections.singleton(dbResult));
        });
    }
    @Override
    public void close() throws Exception {
        dataSource.close();
        executorService.shutdown();
    }

    private boolean checkIsProjectInfo(String isProjectSql){
        boolean result = false;
        Connection connection = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            connection = dataSource.getConnection();
            stmt = connection.prepareStatement(isProjectSql);
            rs = stmt.executeQuery();
            while(rs.next()){
                result = true;
            }
        } catch (Exception e){
            e.printStackTrace();
        }finally {
            try{
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }catch (Exception e){
                e.printStackTrace();
            }
        }
        return result;
    }

    private DeviceCurrentEstimateTagTmp queryFromMySql(CtrEstimateTagEtl ctrEstimateTagEtl)  {
        DeviceCurrentEstimateTagTmp dcett = null;
        boolean isProjectInfo = false;
        String keyWord = ctrEstimateTagEtl.getKeyWord();
        String isProjectSql = null;
        String sql = null;
        String type = ctrEstimateTagEtl.getType();
        if("search".equals(type) && StringUtils.isNotBlank(keyWord)){
            isProjectSql = String.format("select * from api_tag_3_0 where name = '%s' and tag_type = '1'",keyWord);
            sql = String.format("select aggregate_type from api_tag_attr where id = (select tag_attr_id from api_tag_attr_tag where id = (select id from api_tag_3_0 " +
                    "where name = '%s'))",keyWord);
        }
        if(StringUtils.isNotBlank(isProjectSql)){
            isProjectInfo = checkIsProjectInfo(isProjectSql);
            if(isProjectInfo){
                dcett.setProject(keyWord);
            }else{
                dcett.setProject("");
            }
        }
        if(StringUtils.isNotBlank(sql)){
            dcett = findTagInfo(sql,keyWord);
            Date date = new Date();
            dcett.setType(type);
            dcett.setDeviceId(ctrEstimateTagEtl.getDeviceId());
            dcett.setPartitionDate(DateUtils.getDateStr(date));
            dcett.setLastUpdateTime(DateUtils.getTimeStr(date));
        }
        return dcett;
    }

    private DeviceCurrentEstimateTagTmp findTagInfo(String sql, String keyword){
        DeviceCurrentEstimateTagTmp deviceCurrentEstimateTagTmp = null;
        Connection connection = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            connection = dataSource.getConnection();
            stmt = connection.prepareStatement(sql);
            rs = stmt.executeQuery();
            while(rs.next()){
                String aggregate_type = rs.getString("aggregate_type");
                if("7".equals(aggregate_type)){
                    deviceCurrentEstimateTagTmp = new DeviceCurrentEstimateTagTmp();
                    deviceCurrentEstimateTagTmp.setFirstDemands(keyword);
                }else if("10".equals(aggregate_type)){
                    deviceCurrentEstimateTagTmp = new DeviceCurrentEstimateTagTmp();
                    deviceCurrentEstimateTagTmp.setFirstPositions(keyword);
                }else if("6".equals(aggregate_type)){
                    deviceCurrentEstimateTagTmp = new DeviceCurrentEstimateTagTmp();
                    deviceCurrentEstimateTagTmp.setFirstSolutions(keyword);
                }else if("8".equals(aggregate_type)){
                    deviceCurrentEstimateTagTmp = new DeviceCurrentEstimateTagTmp();
                    deviceCurrentEstimateTagTmp.setSecondDemands(keyword);
                }else if("3".equals(aggregate_type)){
                    deviceCurrentEstimateTagTmp = new DeviceCurrentEstimateTagTmp();
                    deviceCurrentEstimateTagTmp.setSecondPositions(keyword);
                }else if("2".equals(aggregate_type)){
                    deviceCurrentEstimateTagTmp = new DeviceCurrentEstimateTagTmp();
                    deviceCurrentEstimateTagTmp.setFirstPositions(keyword);
                }
            }
        } catch (Exception e){
            e.printStackTrace();
        }finally {
            try{
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }catch (Exception e){
                e.printStackTrace();
            }
        }
        return deviceCurrentEstimateTagTmp;
    }
}