package com.gmei.data.ctr.cache;

import java.util.concurrent.Callable;

/**
 * ClassName: CacheService
 * Reason: 缓存抽象类
 * Date: 2020-03-31 13:00:00
 *
 * @author zhaojianwei
 * @since JDK 1.8
 */
public abstract class CacheService<K, V> {
    abstract void invalidate(Object key);
    abstract void putValue(K key, V value);
    abstract Long cacheSize();
    abstract V getValue(K key, Callable<V> callable);
    abstract void clearCache();
}
