package com.gmei.data.ctr.main;

import com.gmei.data.ctr.operator.CtrPfrRctOperator;
import com.gmei.data.ctr.source.MaidianKafkaSource;
import org.apache.flink.api.java.utils.ParameterTool;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;

/**
 * @ClassName ProdCtrPfrRctMain
 * @Description: CTR预估特征实时偏好处理入口
 * @Author apple
 * @Date 2020/3/30
 * @Version V1.0
 **/
public class ProdCtrPfrRctMain {

    public static void main(String[] args) throws Exception{
        // 获取运行参数
        ParameterTool parameterTool = ParameterTool.fromArgs(args);
        String inBrokers = parameterTool.get("inBrokers","test003:9092");
        String batchSize = parameterTool.get("batchSize","1000");
        String maidianInTopic = parameterTool.get("maidianInTopic", "test11");
        String maidianInGroupId = parameterTool.get("maidianInGroupId","ctr-estimate-pfr");
        Integer windowSize = parameterTool.getInt("windowSize",60);
        Integer slideSize = parameterTool.getInt("slideSize",60);
        String outJdbcUrl = parameterTool.get("outJdbcUrl",
                "jdbc:mysql://172.18.44.3:3306/jerry_test?user=root&password=5OqYM^zLwotJ3oSo&autoReconnect=true&useSSL=false");
        Integer maxRetry = parameterTool.getInt("maxRetry",3);
        Long retryInteral = parameterTool.getLong("retryInteral",3000);
        String checkpointPath = parameterTool.get("checkpointPath","hdfs://bj-gmei-hdfs/user/data/flink/ctr-estimate-pfr/checkpoint");
        Boolean isStartFromEarliest = parameterTool.getBoolean("isStartFromEarliest",false);
        Boolean isStartFromLatest = parameterTool.getBoolean("isStartFromLatest",false);
        String startTime = parameterTool.get("startTime");
        Integer parallelism = parameterTool.getInt("parallelism",2);
        String inJerryJdbcUrl = parameterTool.get("inJerryJdbcUrl","jdbc:mysql://172.16.40.170:4000/jerry_test?characterEncoding=UTF-8&autoReconnect=true&useSSL=false");
        String inJerryUsername = parameterTool.get("inJerryUsername","data_user");
        String inJerryPassword = parameterTool.get("inJerryPassword","YPEzp78HQBuhByWPpefQu6X3D6hEPfD6");
        // 参数打印
        System.out.println("**********************************************************");
        System.out.println("*** inBrokers: " + inBrokers);
        System.out.println("*** maidianInTopic: "+ maidianInTopic);
        System.out.println("*** maidianInGroupId: " + maidianInGroupId);
        System.out.println("*** outJdbcUrl: " + outJdbcUrl);
        System.out.println("*** checkpointPath: " + checkpointPath);
        System.out.println("*** startTime: " + startTime);
        System.out.println("*** windowSize: " + windowSize);
        System.out.println("*** slideSize: " + slideSize);
        System.out.println("**********************************************************");
        // 获得流处理环境对象
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        //env.setStreamTimeCharacteristic(TimeCharacteristic.EventTime);
        //        env.enableCheckpointing(1000);
        //        env.setStateBackend(new FsStateBackend(checkpointPath));
        //        env.setRestartStrategy(RestartStrategies.fixedDelayRestart(1, 3000));
        //        CheckpointConfig config = env.getCheckpointConfig();
        //        config.enableExternalizedCheckpoints(CheckpointConfig.ExternalizedCheckpointCleanup.RETAIN_ON_CANCELLATION);
        // 数据输入源
        DataStream MaidianDataStream = new MaidianKafkaSource(
                env,
                inBrokers,
                maidianInTopic,
                maidianInGroupId,
                batchSize,
                isStartFromEarliest,
                isStartFromLatest,
                startTime
        ).getInstance();
        // 执行处理核心逻辑
        new CtrPfrRctOperator(
                MaidianDataStream,
                outJdbcUrl,
                maxRetry,
                retryInteral,
                parallelism,
                inJerryJdbcUrl,
                inJerryUsername,
                inJerryPassword
        ).run();
        // 常驻执行
        env.execute("ctr-estimate-pfr-rct");
    }
}
