package com.gmei.data.ctr.operator;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.gmei.data.ctr.bean.CtrPfrRctEtlBean;
import com.gmei.data.ctr.bean.CtrPfrRctTmpBean;
import com.gmei.data.ctr.sink.CtrPfrRctMysqlSink;
import com.gmei.data.ctr.source.JrAsyncPfrRctSource;
import com.gmei.data.ctr.utils.DateUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.api.common.functions.FilterFunction;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.streaming.api.datastream.AsyncDataStream;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;

import java.util.concurrent.TimeUnit;

/**
 * @ClassName CtrEstimateTagOperator
 * @Description: CTR特征预估标签表
 * @Author zhaojianwei
 * @Date 2020/4/01
 * @Version V1.0
 **/
public class CtrPfrRctOperator implements BaseOperator{
    private DataStream dataStream;
    private String outJdbcUrl;
    private int maxRetry;
    private long retryInteral;
    private int parallelism;
    private String jerryJdbcUrl;
    private String jerryUsername;
    private String jerryPassword;
    public CtrPfrRctOperator(DataStream dataStream, String outJdbcUrl, int maxRetry, long retryInteral, int parallelism,
                             String jerryJdbcUrl, String jerryUsername, String jerryPassword) {
        this.dataStream = dataStream;
        this.outJdbcUrl = outJdbcUrl;
        this.maxRetry = maxRetry;
        this.retryInteral = retryInteral;
        this.parallelism = parallelism;
        this.jerryJdbcUrl = jerryJdbcUrl;
        this.jerryUsername = jerryUsername;
        this.jerryPassword = jerryPassword;
    }
    @Override
    public void run() {
        SingleOutputStreamOperator filter01 = dataStream
                .filter(new FilterFunction<String>() {
                    @Override
                    public boolean filter(String value) throws Exception {
                        return JSON.isValid(value);
                    }
                }).setParallelism(parallelism);
        SingleOutputStreamOperator map01 = filter01
                .map(new MapFunction<String, JSONObject>() {
                    @Override
                    public JSONObject map(String value) throws Exception {
                        return JSON.parseObject(value);
                    }
                }).setParallelism(parallelism);
    // jsonStream.print();
    SingleOutputStreamOperator filter2 =
            map01.filter(
            new FilterFunction<JSONObject>() {
              @Override
              public boolean filter(JSONObject jsonObject) throws Exception {
                Double gmNginxTimestamp = jsonObject.getDouble("gm_nginx_timestamp");
                if (null != gmNginxTimestamp) {
                  long gmNginxTimestampLong = Math.round(gmNginxTimestamp * 1000);
                  String currentDateStr = DateUtils.getCurrentDateStr();
                  long currentDateBegin =
                      DateUtils.getTimestampByDateStr(currentDateStr + " 00:00:00");
                  long currentDateend =
                      DateUtils.getTimestampByDateStr(currentDateStr + " 23:59:59");
                  if (gmNginxTimestampLong >= currentDateBegin
                      && gmNginxTimestampLong <= currentDateend) {
                    String type = jsonObject.getString("type");
                    JSONObject deviceObject = jsonObject.getJSONObject("device");
                    if (null != deviceObject && StringUtils.isNotBlank(type)) {
                      String deviceId = deviceObject.getString("device_id");
                      String idfv = deviceObject.getString("idfv");
                      String clId = "";
                      if (StringUtils.isBlank(deviceId) && StringUtils.isNotBlank(idfv)) {
                        clId = idfv;
                      } else {
                        clId = deviceId;
                      }
                      if (StringUtils.isNotBlank(clId)) {
                        if ("page_view".equals(type)) {
                          JSONObject paramsObject = jsonObject.getJSONObject("params");
                          if (null != paramsObject) {
                            String pageName = paramsObject.getString("page_name");
                            if ("diary_detail".equals(pageName) || "diarybook_detail".equals(pageName)
                                || "user_post_detail".equals(pageName) || "post_detail".equals(pageName)
                                || "welfare_detail".equals(pageName)
                                || "answer_detail".equals(pageName)) {
                              String businessId = paramsObject.getString("business_id");
                              if (null != businessId) {
                                return true;
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                }
                return false;
              }
            }).setParallelism(parallelism);
        //filter.print();
        SingleOutputStreamOperator map02 = filter2
                .map(new MapFunction<JSONObject, CtrPfrRctEtlBean>() {
                    @Override
                    public CtrPfrRctEtlBean map(JSONObject jsonObject) throws Exception {
                        String type = jsonObject.getString("type");
                        JSONObject deviceObject = jsonObject.getJSONObject("device");
                        CtrPfrRctEtlBean ctrPfrRctEtlBean = null;
                        if (null != deviceObject && StringUtils.isNotBlank(type)) {
                            String deviceId = deviceObject.getString("device_id");
                            String idfv = deviceObject.getString("idfv");
                            String clId = "";
                            if (StringUtils.isBlank(deviceId) && StringUtils.isNotBlank(idfv)) {
                                clId = idfv;
                            } else {
                                clId = deviceId;
                            }
                            if (StringUtils.isNotBlank(clId)) {
                                if ("page_view".equals(type)) {
                                    JSONObject paramsObject = jsonObject.getJSONObject("params");
                                    if(null != paramsObject){
                                        String pageName = paramsObject.getString("page_name");
                                        String businessId = paramsObject.getString("business_id");
                                        if(StringUtils.isNotBlank(businessId)){
                                            ctrPfrRctEtlBean = new CtrPfrRctEtlBean();
                                            ctrPfrRctEtlBean.setDeviceId(clId);
                                            ctrPfrRctEtlBean.setStatisticsTypeId(businessId);
                                            if(("diary_detail".equals(pageName) || "diarybook_detail".equals(pageName))){
                                                ctrPfrRctEtlBean.setStatisticsType("diary");
                                            }else if("user_post_detail".equals(pageName) || "post_detail".equals(pageName)){
                                                ctrPfrRctEtlBean.setStatisticsType("tractate");
                                            }else if("welfare_detail".equals(pageName)){
                                                ctrPfrRctEtlBean.setStatisticsType("service");
                                            }else if("answer_detail".equals(pageName)){
                                                ctrPfrRctEtlBean.setStatisticsType("answer");
                                            }
                                        }
                                    }
                                }
                            }
                        }
                        return ctrPfrRctEtlBean;
                    }
                }).setParallelism(parallelism);
        //map.print();
        DataStream<CtrPfrRctTmpBean> tidbAsyncDataStream = AsyncDataStream
                .unorderedWait(map02, new JrAsyncPfrRctSource(jerryJdbcUrl,jerryUsername,jerryPassword), 1, TimeUnit.MINUTES, 1000)
                .uid("tidbAsyncDataStream")
                .setParallelism(parallelism);

        tidbAsyncDataStream
        .addSink(new CtrPfrRctMysqlSink(outJdbcUrl, maxRetry, retryInteral))
        .setParallelism(1);
    }
}
