package com.gmei.data.ctr.operator;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.gmei.data.ctr.bean.CtrTagCrtEtlBean;
import com.gmei.data.ctr.bean.CtrTagCrtTmpBean;
import com.gmei.data.ctr.sink.CtrTagCrtMysqlSink;
import com.gmei.data.ctr.source.ZxAsyncTagCrtSource;
import com.gmei.data.ctr.source.JrAsyncTagCrtSource;
import com.gmei.data.ctr.utils.DateUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.api.common.functions.FilterFunction;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.streaming.api.datastream.AsyncDataStream;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;

import java.util.concurrent.TimeUnit;

/**
 * @ClassName CtrEstimateTagOperator
 * @Description: CTR特征预估标签表
 * @Author zhaojianwei
 * @Date 2020/4/01
 * @Version V1.0
 **/
public class CtrTagCrtOperator implements BaseOperator{
    private DataStream dataStream;
    private String outJdbcUrl;
    private int maxRetry;
    private long retryInteral;
    private int parallelism;
    private int windowSize;
    private int slideSize;
    private String zxJdbcUrl;
    private String zxUsername;
    private String zxPassword;
    private String jerryJdbcUrl;
    private String jerryUsername;
    private String jerryPassword;

    public CtrTagCrtOperator(DataStream dataStream, String outJdbcUrl, int maxRetry, long retryInteral, int parallelism,
                             int windowSize, int slideSize, String zxJdbcUrl, String zxUsername, String zxPassword,
                             String jerryJdbcUrl, String jerryUsername, String jerryPassword) {
        this.dataStream = dataStream;
        this.outJdbcUrl = outJdbcUrl;
        this.maxRetry = maxRetry;
        this.retryInteral = retryInteral;
        this.parallelism = parallelism;
        this.windowSize = windowSize;
        this.slideSize = slideSize;
        this.zxJdbcUrl = zxJdbcUrl;
        this.zxUsername = zxUsername;
        this.zxPassword = zxPassword;
        this.jerryJdbcUrl = jerryJdbcUrl;
        this.jerryUsername = jerryUsername;
        this.jerryPassword = jerryPassword;
    }

    @Override
    public void run() {
        SingleOutputStreamOperator jsonStream = dataStream
                .filter(new FilterFunction<String>() {
                    @Override
                    public boolean filter(String value) throws Exception {
                        return JSON.isValid(value);
                    }
                })
                .map(new MapFunction<String, JSONObject>() {
                    @Override
                    public JSONObject map(String value) throws Exception {
                        return JSON.parseObject(value);
                    }
                });
        //jsonStream.print();
        SingleOutputStreamOperator filter = jsonStream
                .filter(new FilterFunction<JSONObject>() {
                    @Override
                    public boolean filter(JSONObject jsonObject) throws Exception {
                        Double gmNginxTimestamp = jsonObject.getDouble("gm_nginx_timestamp");
                        if (null != gmNginxTimestamp) {
                            long gmNginxTimestampLong = Math.round(gmNginxTimestamp * 1000);
                            String currentDateStr = DateUtils.getCurrentDateStr();
                            long currentDateBegin = DateUtils.getTimestampByDateStr(currentDateStr + " 00:00:00");
                            long currentDateend = DateUtils.getTimestampByDateStr(currentDateStr + " 23:59:59");
                            if (gmNginxTimestampLong >= currentDateBegin && gmNginxTimestampLong <= currentDateend) {
                                String type = jsonObject.getString("type");
                                JSONObject paramsObject = jsonObject.getJSONObject("params");
                                JSONObject deviceObject = jsonObject.getJSONObject("device");
                                if (null != paramsObject && null != deviceObject && StringUtils.isNotBlank(type)) {
                                    String deviceId = deviceObject.getString("device_id");
                                    String idfv = deviceObject.getString("idfv");
                                    String clId = "";
                                    if (StringUtils.isBlank(deviceId) && StringUtils.isNotBlank(idfv)) {
                                        clId = idfv;
                                    } else {
                                        clId = deviceId;
                                    }
                                    if (StringUtils.isNotBlank(clId)) {
                                        String cardContentType = paramsObject.getString("card_content_type");
                                        String cardIdStr = paramsObject.getString("card_id");
                                        if (null != cardContentType && null != cardIdStr) {
                                            try {
                                                Long.valueOf(cardIdStr);
                                            } catch (Exception e) {
                                                e.printStackTrace();
                                                return false;
                                            }
                                            if ("service".equals(cardContentType) || "diary".equals(cardContentType) ||
                                                    "tractate".equals(cardContentType) || "answer".equals(cardContentType)) {
                                                return true;
                                            }
                                        }
                                        if (("do_serach".equals(type) || "search_result_click_search".equals(type)) && StringUtils.isNotBlank(paramsObject.getString("query"))) {
                                            return true;
                                        }
                                        if ("on_click_card".equals(type) && null != paramsObject.getString("card_type") && "search_word".equals(paramsObject.getString("card_type"))
                                                && StringUtils.isNotBlank(paramsObject.getString("card_name"))) {
                                            return true;
                                        }
                                    }
                                }
                            }
                        }
                        return false;
                    }
                });
        //filter.print();
        SingleOutputStreamOperator map = filter
                .map(new MapFunction<JSONObject, CtrTagCrtEtlBean>() {
                    @Override
                    public CtrTagCrtEtlBean map(JSONObject jsonObject) throws Exception {
                        String type = jsonObject.getString("type");
                        JSONObject paramsObject = jsonObject.getJSONObject("params");
                        JSONObject deviceObject = jsonObject.getJSONObject("device");
                        CtrTagCrtEtlBean ctrTagCrtEtlBean = new CtrTagCrtEtlBean();
                        if (null != paramsObject && null != deviceObject && StringUtils.isNotBlank(type)) {
                            String deviceId = deviceObject.getString("device_id");
                            String idfv = deviceObject.getString("idfv");
                            String clId = "";
                            if (StringUtils.isBlank(deviceId) && StringUtils.isNotBlank(idfv)) {
                                clId = idfv;
                            } else {
                                clId = deviceId;
                            }
                            if (StringUtils.isNotBlank(clId)) {
                                String cardContentType = paramsObject.getString("card_content_type");
                                String cardIdStr = paramsObject.getString("card_id");
                                ctrTagCrtEtlBean.setDeviceId(deviceId);
                                if (null != cardContentType && null != cardIdStr) {
                                    Long cardId = Long.valueOf(cardIdStr);
                                    ctrTagCrtEtlBean.setCardId(cardId);
                                    ctrTagCrtEtlBean.setCardContentType(cardContentType);
                                    if ("service".equals(cardContentType) ) {
                                        ctrTagCrtEtlBean.setType("commodity");
                                    }
                                    if("diary".equals(cardContentType) || "tractate".equals(cardContentType) || "answer".equals(cardContentType)){
                                        ctrTagCrtEtlBean.setType("content");
                                    }
                                }
                                if(("do_serach".equals(type) || "search_result_click_search".equals(type)) && StringUtils.isNotBlank(paramsObject.getString("query"))){
                                    ctrTagCrtEtlBean.setType("search");
                                    ctrTagCrtEtlBean.setKeyWord(paramsObject.getString("query"));
                                }
                                if ("on_click_card".equals(type) && null != paramsObject.getString("card_type") && "search_word".equals(paramsObject.getString("card_type"))
                                        && StringUtils.isNotBlank(paramsObject.getString("card_name"))){
                                    ctrTagCrtEtlBean.setType("search");
                                    ctrTagCrtEtlBean.setKeyWord(paramsObject.getString("card_name"));
                                }
                            }
                        }
                        return ctrTagCrtEtlBean;
                    }
                });
        //map.print();
        DataStream<CtrTagCrtTmpBean> tidbAsyncDataStream = AsyncDataStream
                .unorderedWait(map, new JrAsyncTagCrtSource(jerryJdbcUrl,jerryUsername,jerryPassword), 1, TimeUnit.MINUTES, 1000)
                .uid("tidbAsyncDataStream")
                .setParallelism(parallelism);
        DataStream<CtrTagCrtTmpBean> zhengxingAsyncDataStream = AsyncDataStream
                .unorderedWait(map, new ZxAsyncTagCrtSource(zxJdbcUrl,zxUsername,zxPassword), 1, TimeUnit.MINUTES, 1000)
                .uid("zhengxingAsyncDataStream")
                .setParallelism(parallelism);
        DataStream<CtrTagCrtTmpBean> asyncDataStream = tidbAsyncDataStream.union(zhengxingAsyncDataStream);

        asyncDataStream
        .addSink(new CtrTagCrtMysqlSink(outJdbcUrl, maxRetry, retryInteral))
        .setParallelism(parallelism);
    }
}
