package com.gmei.data.ctr.sink;

import com.gmei.data.ctr.bean.CtrPfrCrtTmpBean;
import com.gmei.data.ctr.common.Constants;
import com.gmei.data.ctr.utils.DateUtils;
import com.gmei.data.ctr.utils.JDBCUtils;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.sink.RichSinkFunction;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;

/**
 * @ClassName CtrPfrCrtMysqlSink
 * @Description: CTR特征预估偏好MysqlSink
 * @Author zhaojianwei
 * @Date 2020/3/31
 * @Version V1.0
 **/
public class CtrPfrCrtMysqlSink extends RichSinkFunction<CtrPfrCrtTmpBean> {
    private int maxRetry;
    private long retryInteral;
    private String jdbcUrl;
    private Connection connection;
    public CtrPfrCrtMysqlSink(String jdbcUrl, int maxRetry, long retryInteral) {
        this.jdbcUrl = jdbcUrl;
        this.maxRetry = maxRetry;
        this.retryInteral = retryInteral;
    }
    @Override
    public void open(Configuration parameters) throws Exception {
        Class.forName(Constants.MYSQL_DRIVER_CLASS);
        connection = DriverManager.getConnection(jdbcUrl);
        super.open(parameters);
    }
    @Override
    public void invoke(CtrPfrCrtTmpBean ctrPfrCrtTmpBean, Context context) throws Exception {
        try {
            insertAndDel(ctrPfrCrtTmpBean);
        }catch (Exception e){
            e.printStackTrace();
            int numReties = 1;
            Exception lastException = e;
            while (numReties <= maxRetry){
                try {
                    numReties++;
                    Thread.sleep(retryInteral);
                    insertAndDel(ctrPfrCrtTmpBean);
                }catch (Exception e1){
                    lastException = e1;
                    continue;
                }
                return;
            }
            throw lastException;
        }
    }
    @Override
    public void close() throws Exception {
        JDBCUtils.close(connection,null,null);
        super.close();
    }

    /**
     * 插入最新数据
     * @param ctrPfrCrtTmpBean
     * @throws SQLException
     */
    private void insertAndDel(CtrPfrCrtTmpBean ctrPfrCrtTmpBean)  {
        Statement statement = null;
        Date date = new Date();
        if(null != ctrPfrCrtTmpBean){
            try{
                statement = connection.createStatement();
                statement.executeUpdate(
                        String.format(
                                "insert into device_current_estimate_view_pfr("+
                                        "device_id," +
                                        "statistics_type," +
                                        "statistics_type_id," +
                                        "project_pfr," +
                                        "first_demands_pfr," +
                                        "first_positions_pfr," +
                                        "first_solutions_pfr," +
                                        "second_demands_pfr," +
                                        "second_positions_pfr," +
                                        "second_solutions_pfr," +
                                        "partition_date," +
                                        "last_update_time"
                                        + ") values ('%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s')",
                                ctrPfrCrtTmpBean.getDeviceId(),
                                ctrPfrCrtTmpBean.getStatisticsType(),
                                ctrPfrCrtTmpBean.getStatisticsTypeId(),
                                ctrPfrCrtTmpBean.getProjectPfr(),
                                ctrPfrCrtTmpBean.getFirstDemandsPfr(),
                                ctrPfrCrtTmpBean.getFirstPositionsPfr(),
                                ctrPfrCrtTmpBean.getFirstSolutionsPfr(),
                                ctrPfrCrtTmpBean.getSecondDemandsPfr(),
                                ctrPfrCrtTmpBean.getSecondPositionsPfr(),
                                ctrPfrCrtTmpBean.getSecondSolutionsPfr(),
                                DateUtils.getDateStr(date),
                                DateUtils.getTimeStr(date)
                        )
                );
                JDBCUtils.close(null,statement,null);
            }catch (Exception e){
                e.printStackTrace();
            }
        }
    }
}
