package com.gmei.data.ctr.sink;

import com.gmei.data.ctr.bean.CtrPfrRctTmpBean;
import com.gmei.data.ctr.common.Constants;
import com.gmei.data.ctr.utils.DateUtils;
import com.gmei.data.ctr.utils.JDBCUtils;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.sink.RichSinkFunction;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;

/**
 * @ClassName CtrEstimatePfrMysqlSink
 * @Description: CTR特征预估偏好MysqlSink
 * @Author zhaojianwei
 * @Date 2020/3/31
 * @Version V1.0
 **/
public class CtrPfrRctMysqlSink extends RichSinkFunction<CtrPfrRctTmpBean> {
    private int maxRetry;
    private long retryInteral;
    private String jdbcUrl;
    private Connection connection;
    public CtrPfrRctMysqlSink(String jdbcUrl, int maxRetry, long retryInteral) {
        this.jdbcUrl = jdbcUrl;
        this.maxRetry = maxRetry;
        this.retryInteral = retryInteral;
    }
    @Override
    public void open(Configuration parameters) throws Exception {
        Class.forName(Constants.MYSQL_DRIVER_CLASS);
        connection = DriverManager.getConnection(jdbcUrl);
        super.open(parameters);
    }
    @Override
    public void invoke(CtrPfrRctTmpBean ctrPfrRctTmpBean, Context context) throws Exception {
        try {
            insertAndDel(ctrPfrRctTmpBean);
        }catch (Exception e){
            e.printStackTrace();
            int numReties = 1;
            Exception lastException = e;
            while (numReties <= maxRetry){
                try {
                    numReties++;
                    Thread.sleep(retryInteral);
                    insertAndDel(ctrPfrRctTmpBean);
                }catch (Exception e1){
                    lastException = e1;
                    continue;
                }
                return;
            }
            throw lastException;
        }
    }
    @Override
    public void close() throws Exception {
        JDBCUtils.close(connection,null,null);
        super.close();
    }

    /**
     * 插入最新数据
     * @param ctrPfrRctTmpBean
     * @throws SQLException
     */
    private void insertAndDel(CtrPfrRctTmpBean ctrPfrRctTmpBean)  {
        Statement statement = null;
        Date date = new Date();
        if(null != ctrPfrRctTmpBean){
            try{
                statement = connection.createStatement();
                statement.executeUpdate(
                        String.format(
                                "insert into device_recently_estimate_view_pfr("+
                                        "device_id," +
                                        "statistics_type," +
                                        "statistics_type_id," +
                                        "project_pfr," +
                                        "first_demands_pfr," +
                                        "first_positions_pfr," +
                                        "first_solutions_pfr," +
                                        "second_demands_pfr," +
                                        "second_positions_pfr," +
                                        "second_solutions_pfr," +
                                        "last_update_time"
                                        + ") values ('%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s')",
                                ctrPfrRctTmpBean.getDeviceId(),
                                ctrPfrRctTmpBean.getStatisticsType(),
                                ctrPfrRctTmpBean.getStatisticsTypeId(),
                                ctrPfrRctTmpBean.getProjectPfr(),
                                ctrPfrRctTmpBean.getFirstDemandsPfr(),
                                ctrPfrRctTmpBean.getFirstPositionsPfr(),
                                ctrPfrRctTmpBean.getFirstSolutionsPfr(),
                                ctrPfrRctTmpBean.getSecondDemandsPfr(),
                                ctrPfrRctTmpBean.getSecondPositionsPfr(),
                                ctrPfrRctTmpBean.getSecondSolutionsPfr(),
                                DateUtils.getTimeStr(date)
                        )
                );
                statement.executeUpdate(
                        String.format(
                                "delete from device_recently_estimate_view_pfr where " +
                                        "device_id = '%s' and " +
                                        "statistics_type = '%s' and " +
                                        "statistics_type_id = '%s' and " +
                                        "last_update_time <= '%s'",
                                ctrPfrRctTmpBean.getDeviceId(),
                                ctrPfrRctTmpBean.getStatisticsType(),
                                ctrPfrRctTmpBean.getStatisticsTypeId(),
                                DateUtils.getSevenDaysAgoTimeStr(date)
                        )
                );
                JDBCUtils.close(null,statement,null);
            }catch (Exception e){
                e.printStackTrace();
            }
        }
    }
}
