package com.gmei.data.ctr.operator;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.gmei.data.ctr.bean.CtrPfrCrtEtlBean;
import com.gmei.data.ctr.bean.CtrPfrCrtBean;
import com.gmei.data.ctr.sink.CtrPfrCrtMysqlSink;
import com.gmei.data.ctr.source.JrAsyncPfrCrtSource;
import com.gmei.data.ctr.utils.DateUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.api.common.functions.FilterFunction;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.streaming.api.datastream.AsyncDataStream;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;

import java.util.concurrent.TimeUnit;

/**
 * @ClassName CtrPfrCrtOperator
 * @Description: CTR特征预估当天偏好算子
 * @Author zhaojianwei
 * @Date 2020/4/01
 * @Version V1.0
 **/
public class CtrPfrCrtOperator implements BaseOperator{
    private DataStream dataStream;
    private String outJdbcUrl;
    private int maxRetry;
    private long retryInteral;
    private int parallelism;
    private String jerryJdbcUrl;
    private String jerryUsername;
    private String jerryPassword;
    public CtrPfrCrtOperator(DataStream dataStream, String outJdbcUrl, int maxRetry, long retryInteral, int parallelism,
                             String jerryJdbcUrl, String jerryUsername, String jerryPassword) {
        this.dataStream = dataStream;
        this.outJdbcUrl = outJdbcUrl;
        this.maxRetry = maxRetry;
        this.retryInteral = retryInteral;
        this.parallelism = parallelism;
        this.jerryJdbcUrl = jerryJdbcUrl;
        this.jerryUsername = jerryUsername;
        this.jerryPassword = jerryPassword;
    }
    @Override
    public void run() {
        SingleOutputStreamOperator filter01 = dataStream
                .filter(new FilterFunction<String>() {
                    @Override
                    public boolean filter(String value) throws Exception {
                        return JSON.isValid(value);
                    }
                }).setParallelism(parallelism);
        SingleOutputStreamOperator map01 = filter01
                .map(new MapFunction<String, JSONObject>() {
                    @Override
                    public JSONObject map(String value) throws Exception {
                        return JSON.parseObject(value);
                    }
                }).setParallelism(parallelism);
    SingleOutputStreamOperator filter2 =
            map01.filter(
            new FilterFunction<JSONObject>() {
              @Override
              public boolean filter(JSONObject jsonObject) throws Exception {
                Double gmNginxTimestamp = jsonObject.getDouble("gm_nginx_timestamp");
                if (null != gmNginxTimestamp) {
                  long gmNginxTimestampLong = Math.round(gmNginxTimestamp * 1000);
                  String currentDateStr = DateUtil.getCurrentDateStr();
                  long currentDateBegin =
                      DateUtil.getTimestampByDateStr(currentDateStr + " 00:00:00");
                  long currentDateend =
                      DateUtil.getTimestampByDateStr(currentDateStr + " 23:59:59");
                  if (gmNginxTimestampLong >= currentDateBegin
                      && gmNginxTimestampLong <= currentDateend) {
                    String type = jsonObject.getString("type");
                    JSONObject deviceObject = jsonObject.getJSONObject("device");
                    if (null != deviceObject && StringUtils.isNotBlank(type)) {
                      String deviceId = deviceObject.getString("device_id");
                      String idfv = deviceObject.getString("idfv");
                      String clId = "";
                      if (StringUtils.isBlank(deviceId) && StringUtils.isNotBlank(idfv)) {
                        clId = idfv;
                      } else {
                        clId = deviceId;
                      }
                      if (StringUtils.isNotBlank(clId)) {
                        if ("page_view".equals(type)) {
                          JSONObject paramsObject = jsonObject.getJSONObject("params");
                          if (null != paramsObject) {
                            String pageName = paramsObject.getString("page_name");
                            if ("diary_detail".equals(pageName) || "diarybook_detail".equals(pageName)
                                || "user_post_detail".equals(pageName) || "post_detail".equals(pageName)
                                || "welfare_detail".equals(pageName)
                                || "answer_detail".equals(pageName)) {
                              String businessId = paramsObject.getString("business_id");
                              if (null != businessId) {
                                return true;
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                }
                return false;
              }
            }).setParallelism(parallelism);
        SingleOutputStreamOperator map02 = filter2
                .map(new MapFunction<JSONObject, CtrPfrCrtEtlBean>() {
                    @Override
                    public CtrPfrCrtEtlBean map(JSONObject jsonObject) throws Exception {
                        String type = jsonObject.getString("type");
                        JSONObject deviceObject = jsonObject.getJSONObject("device");
                        CtrPfrCrtEtlBean ctrPfrCrtEtlBean = null;
                        if (null != deviceObject && StringUtils.isNotBlank(type)) {
                            String deviceId = deviceObject.getString("device_id");
                            String idfv = deviceObject.getString("idfv");
                            String clId = "";
                            if (StringUtils.isBlank(deviceId) && StringUtils.isNotBlank(idfv)) {
                                clId = idfv;
                            } else {
                                clId = deviceId;
                            }
                            if (StringUtils.isNotBlank(clId)) {
                                if ("page_view".equals(type)) {
                                    JSONObject paramsObject = jsonObject.getJSONObject("params");
                                    if(null != paramsObject){
                                        String pageName = paramsObject.getString("page_name");
                                        String businessId = paramsObject.getString("business_id");
                                        if(StringUtils.isNotBlank(businessId)){
                                            ctrPfrCrtEtlBean = new CtrPfrCrtEtlBean();
                                            ctrPfrCrtEtlBean.setDeviceId(clId);
                                            ctrPfrCrtEtlBean.setStatisticsTypeId(businessId);
                                            if(("diary_detail".equals(pageName) || "diarybook_detail".equals(pageName))){
                                                ctrPfrCrtEtlBean.setStatisticsType("diary");
                                            }else if("user_post_detail".equals(pageName) || "post_detail".equals(pageName)){
                                                ctrPfrCrtEtlBean.setStatisticsType("tractate");
                                            }else if("welfare_detail".equals(pageName)){
                                                ctrPfrCrtEtlBean.setStatisticsType("service");
                                            }else if("answer_detail".equals(pageName)){
                                                ctrPfrCrtEtlBean.setStatisticsType("answer");
                                            }
                                        }
                                    }
                                }
                            }
                        }
                        return ctrPfrCrtEtlBean;
                    }
                }).setParallelism(parallelism);
        DataStream<CtrPfrCrtBean> tidbAsyncDataStream = AsyncDataStream
                .unorderedWait(map02, new JrAsyncPfrCrtSource(jerryJdbcUrl,jerryUsername,jerryPassword), 1, TimeUnit.MINUTES, 1000)
                .uid("tidbAsyncDataStream")
                .setParallelism(parallelism);

        tidbAsyncDataStream
        .addSink(new CtrPfrCrtMysqlSink(outJdbcUrl, maxRetry, retryInteral))
        .setParallelism(1);
    }
}
