#!/bin/bash

# */5 * * * * /srv/apps/ctr-estimate/bin/auto.sh >> /data/log/ctr-estimate/auto.out

echo "*************************************************************"
task_names=(ctr-estimate-clk-crt ctr-estimate-pfr-crt ctr-estimate-pfr-rct ctr-estimate-tag-crt)
for element in "${task_names[@]}"
  do
    app_id=`/opt/hadoop-2.6.0-cdh5.16.1/bin/yarn application -list | grep -w $element | awk '{print $1}'`
    if [[ -z $app_id ]];then
      if [ "ctr-estimate-clk-crt" == "$element" ];then
        nohup /srv/apps/ctr-estimate/bin/start_clk_crt.sh >/dev/null 2>&1 &
        echo `date +"%Y-%m-%d %H:%M:%S"`": Restart task "$element" ..."
      elif [ "ctr-estimate-pfr-crt" == "$element" ]; then
        nohup /srv/apps/ctr-estimate/bin/start_pfr_crt.sh >/dev/null 2>&1 &
        echo `date +"%Y-%m-%d %H:%M:%S"`": Restart task "$element" ..."
      elif [ "ctr-estimate-pfr-rct" == "$element" ]; then
        nohup /srv/apps/ctr-estimate/bin/start_pfr_rct.sh >/dev/null 2>&1 &
        echo `date +"%Y-%m-%d %H:%M:%S"`": Restart task "$element" ..."
      elif [ "ctr-estimate-tag-crt" == "$element" ]; then
        nohup /srv/apps/ctr-estimate/bin/start_tag_crt.sh >/dev/null 2>&1 &
        echo `date +"%Y-%m-%d %H:%M:%S"`": Restart task "$element" ..."
      else
        echo $element" is not a valid task name, please check it again!"
      fi
    else
      echo `date +"%Y-%m-%d %H:%M:%S"`": Task "$element" is running ..."
    fi
  done
