package com.gmei.data.ctr.sink;

import com.gmei.data.ctr.bean.CtrPfrCrtBean;
import com.gmei.data.ctr.common.Constants;
import com.gmei.data.ctr.utils.DateUtil;
import com.gmei.data.ctr.utils.JDBCUtil;
import com.gmei.data.ctr.utils.StringUtil;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.sink.RichSinkFunction;

import java.sql.*;
import java.util.Date;

/**
 * @ClassName CtrPfrCrtMysqlSink
 * @Description: CTR特征预估偏好MysqlSink
 * @Author zhaojianwei
 * @Date 2020/3/31
 * @Version V1.0
 **/
public class CtrPfrCrtMysqlSink extends RichSinkFunction<CtrPfrCrtBean> {
    private int maxRetry;
    private long retryInteral;
    private String jdbcUrl;
    private Connection connection;
    public CtrPfrCrtMysqlSink(String jdbcUrl, int maxRetry, long retryInteral) {
        this.jdbcUrl = jdbcUrl;
        this.maxRetry = maxRetry;
        this.retryInteral = retryInteral;
    }
    @Override
    public void open(Configuration parameters) throws Exception {
        Class.forName(Constants.MYSQL_DRIVER_CLASS);
        connection = DriverManager.getConnection(jdbcUrl);
        super.open(parameters);
    }
    @Override
    public void invoke(CtrPfrCrtBean ctrPfrCrtBean, Context context) throws Exception {
        try {
            insertAndDel(ctrPfrCrtBean);
        }catch (Exception e){
            e.printStackTrace();
            int numReties = 1;
            Exception lastException = e;
            while (numReties <= maxRetry){
                try {
                    numReties++;
                    Thread.sleep(retryInteral);
                    insertAndDel(ctrPfrCrtBean);
                }catch (Exception e1){
                    lastException = e1;
                    continue;
                }
                return;
            }
            throw lastException;
        }
    }
    @Override
    public void close() throws Exception {
        JDBCUtil.close(connection,null,null);
        super.close();
    }

    /**
     * 插入最新数据
     * @param ctrPfrCrtBean
     * @throws SQLException
     */
    private void insertAndDel(CtrPfrCrtBean ctrPfrCrtBean)  {
        Statement statement = null;
        Date date = new Date();
        if(null != ctrPfrCrtBean){
            boolean isExist = false;
            String projectPfr="";
            String firstDemandsPfr="";
            String firstPositionsPfr="";
            String firstSolutionsPfr="";
            String secondDemandsPfr="";
            String secondPositionsPfr="";
            String secondSolutionsPfr="";
            try{
                statement = connection.createStatement();
                ResultSet resultSet = statement.executeQuery(
                        String.format(
                                "select " +
                                        "project_pfr," +
                                        "first_demands_pfr," +
                                        "first_positions_pfr," +
                                        "first_solutions_pfr," +
                                        "second_demands_pfr," +
                                        "second_positions_pfr," +
                                        "second_solutions_pfr " +
                                        "from device_current_estimate_view_pfr " +
                                        "where device_id = '%s' and statistics_type = '%s' and statistics_type_id = '%s' and partition_date = '%s'",
                                ctrPfrCrtBean.getDeviceId(),
                                ctrPfrCrtBean.getStatisticsType(),
                                ctrPfrCrtBean.getStatisticsTypeId(),
                                DateUtil.getDateStr(date)
                        )
                );
                if (resultSet.next()){
                    isExist = true;
                    projectPfr=resultSet.getString("project_pfr");
                    firstDemandsPfr=resultSet.getString("first_demands_pfr");
                    firstPositionsPfr=resultSet.getString("first_positions_pfr");
                    firstSolutionsPfr=resultSet.getString("first_solutions_pfr");
                    secondDemandsPfr=resultSet.getString("second_demands_pfr");
                    secondPositionsPfr=resultSet.getString("second_positions_pfr");
                    secondSolutionsPfr=resultSet.getString("second_solutions_pfr");
                }
                if(isExist){
                    statement.executeUpdate(
                            String.format(
                                    "update device_current_estimate_view_pfr set "+
                                            "project_pfr = '%s'," +
                                            "first_demands_pfr = '%s'," +
                                            "first_positions_pfr = '%s'," +
                                            "first_solutions_pfr = '%s'," +
                                            "second_demands_pfr = '%s'," +
                                            "second_positions_pfr = '%s'," +
                                            "second_solutions_pfr = '%s'," +
                                            "last_update_time = '%s' " +
                                            "where device_id = '%s' and statistics_type = '%s' and statistics_type_id = '%s' and partition_date = '%s'",
                                    StringUtil.increasePfr(projectPfr,ctrPfrCrtBean.getProjectPfr()),
                                    StringUtil.increasePfr(firstDemandsPfr,ctrPfrCrtBean.getFirstDemandsPfr()),
                                    StringUtil.increasePfr(firstPositionsPfr,ctrPfrCrtBean.getFirstPositionsPfr()),
                                    StringUtil.increasePfr(firstSolutionsPfr,ctrPfrCrtBean.getFirstSolutionsPfr()),
                                    StringUtil.increasePfr(secondDemandsPfr,ctrPfrCrtBean.getSecondDemandsPfr()),
                                    StringUtil.increasePfr(secondPositionsPfr,ctrPfrCrtBean.getSecondPositionsPfr()),
                                    StringUtil.increasePfr(secondSolutionsPfr,ctrPfrCrtBean.getSecondSolutionsPfr()),
                                    DateUtil.getTimeStr(date),
                                    ctrPfrCrtBean.getDeviceId(),
                                    ctrPfrCrtBean.getStatisticsType(),
                                    ctrPfrCrtBean.getStatisticsTypeId(),
                                    DateUtil.getDateStr(date)
                            )
                    );
                }else{
                    statement.executeUpdate(
                            String.format(
                                    "insert into device_current_estimate_view_pfr("+
                                            "device_id," +
                                            "statistics_type," +
                                            "statistics_type_id," +
                                            "project_pfr," +
                                            "first_demands_pfr," +
                                            "first_positions_pfr," +
                                            "first_solutions_pfr," +
                                            "second_demands_pfr," +
                                            "second_positions_pfr," +
                                            "second_solutions_pfr," +
                                            "partition_date," +
                                            "last_update_time"
                                            + ") values ('%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s')",
                                    ctrPfrCrtBean.getDeviceId(),
                                    ctrPfrCrtBean.getStatisticsType(),
                                    ctrPfrCrtBean.getStatisticsTypeId(),
                                    StringUtil.transString2PairedString(ctrPfrCrtBean.getProjectPfr()),
                                    StringUtil.transString2PairedString(ctrPfrCrtBean.getFirstDemandsPfr()),
                                    StringUtil.transString2PairedString(ctrPfrCrtBean.getFirstPositionsPfr()),
                                    StringUtil.transString2PairedString(ctrPfrCrtBean.getFirstSolutionsPfr()),
                                    StringUtil.transString2PairedString(ctrPfrCrtBean.getSecondDemandsPfr()),
                                    StringUtil.transString2PairedString(ctrPfrCrtBean.getSecondPositionsPfr()),
                                    StringUtil.transString2PairedString(ctrPfrCrtBean.getSecondSolutionsPfr()),
                                    DateUtil.getDateStr(date),
                                    DateUtil.getTimeStr(date)
                            )
                    );
                }
                JDBCUtil.close(null,statement,null);
            }catch (Exception e){
                e.printStackTrace();
            }
        }
    }
}
