package com.gmei.data.ctr.callable;


import com.gmei.data.ctr.bean.DeviceCurrentEstimate;
import com.gmei.data.ctr.common.Constants;
import com.gmei.data.ctr.utils.JDBCUtils;

import java.sql.*;
import java.util.concurrent.Callable;

/**
 * ClassName: CurrentEstimateCallable
 * Date: 2020-03-31 16:00:00
 * @author zhaojianwei
 * @since JDK 1.8
 */
public class CurrentEstimateCallable implements Callable<DeviceCurrentEstimate>{
    private String jdbcUrl;
    private String deviceId;
    private String partitionDate;

    public CurrentEstimateCallable(String jdbcUrl, String deviceId, String partitionDate) {
        this.jdbcUrl = jdbcUrl;
        this.deviceId = deviceId;
        this.partitionDate = partitionDate;
    }

    @Override
    public DeviceCurrentEstimate call() throws Exception {
        Connection connection = open();
        DeviceCurrentEstimate dce = findEstimateInfo(deviceId,partitionDate, connection);
        close(connection);
        return dce;
    }

    private Connection open() throws Exception {
        Class.forName(Constants.MYSQL_DRIVER_CLASS);
        return DriverManager.getConnection(jdbcUrl);
    }

    private void close(Connection connection) throws Exception {
        JDBCUtils.close(connection,null,null);
    }

    private DeviceCurrentEstimate findEstimateInfo(String deviceId,String partitionDate, Connection connection) throws SQLException {
        Statement statement = connection.createStatement();
    ResultSet resultSet =
        statement.executeQuery(
            String.format(
                "select \n"
                    + "  device_id,\n"
                    + "  content_card_click,\n"
                    + "  tractate_card_click,\n"
                    + "  answer_card_click,\n"
                    + "  plat_first_positions,\n"
                    + "  plat_first_solutions,\n"
                    + "  plat_first_demands,\n"
                    + "  plat_project,\n"
                    + "  content_first_positions,\n"
                    + "  content_first_solutions,\n"
                    + "  content_first_demands,\n"
                    + "  content_project,\n"
                    + "  commodity_first_positions,\n"
                    + "  commodity_first_solutions,\n"
                    + "  commodity_first_demands,\n"
                    + "  commodity_project,\n"
                    + "  plat_second_positions,\n"
                    + "  plat_second_solutions,\n"
                    + "  plat_second_demands,\n"
                    + "  content_second_positions,\n"
                    + "  content_second_solutions,\n"
                    + "  content_second_demands,\n"
                    + "  commodity_second_positions,\n"
                    + "  commodity_second_solutions,\n"
                    + "  commodity_second_demands,\n"
                    + "  partition_date,\n"
                    + "  last_update_time\n"
                    + "from \n"
                    + "  device_current_estimate \n"
                    + "where \n"
                    + "  device_id = '%s' and \n"
                    + "  partition_date = '%s'",
                deviceId,partitionDate));
        DeviceCurrentEstimate result = null;
        if(resultSet.next()){
            result = new DeviceCurrentEstimate();
            result.setDeviceId(resultSet.getString("device_id"));
            result.setContentCardClick(resultSet.getLong("content_card_click"));
            result.setTractateCardClick(resultSet.getLong("tractate_card_click"));
            result.setAnswerCardClick(resultSet.getLong("answer_card_click"));
            result.setPlatFirstPositions(resultSet.getString("plat_first_positions"));
            result.setPlatFirstSolutions(resultSet.getString("plat_first_solutions"));
            result.setPlatFirstDemands(resultSet.getString("plat_first_demands"));
            result.setPlatProject(resultSet.getString("plat_project"));
            result.setContentFirstPositions(resultSet.getString("content_first_positions"));
            result.setContentFirstSolutions(resultSet.getString("content_first_solutions"));
            result.setContentFirstDemands(resultSet.getString("content_first_demands"));
            result.setContentProject(resultSet.getString("content_project"));
            result.setCommodityFirstpositions(resultSet.getString("commodity_first_positions"));
            result.setCommodityFirstSolutions(resultSet.getString("commodity_first_solutions"));
            result.setCommodityFirstDemands(resultSet.getString("commodity_first_demands"));
            result.setCommodityProject(resultSet.getString("commodity_project"));
            result.setPlatSecondPositions(resultSet.getString("plat_second_positions"));
            result.setPlatSecondSolutions(resultSet.getString("plat_second_solutions"));
            result.setPlatSecondDemands(resultSet.getString("plat_second_demands"));
            result.setContentSecondPositions(resultSet.getString("content_second_positions"));
            result.setContentSecondSolutions(resultSet.getString("content_second_solutions"));
            result.setContentSecondDemands(resultSet.getString("content_second_demands"));
            result.setCommoditySecondPositions(resultSet.getString("commodity_second_positions"));
            result.setCommoditySecondSolutions(resultSet.getString("commodity_second_solutions"));
            result.setCommoditySecondDemands(resultSet.getString("commodity_second_demands"));
            result.setPartitionDate(resultSet.getString("partition_date"));
            result.setLastUpdateTime(resultSet.getString("last_update_time"));
        }
        JDBCUtils.close(null,statement,resultSet);
        return result;
    }
}
