package com.gmei.data.ctr.source;

import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.streaming.connectors.kafka.FlinkKafkaConsumer;

import java.text.ParseException;
import java.util.Properties;

/**
 * ClassName: GmeiKafkaSource
 * Reason: kafka日志源
 * Date: 2020-03-31 18:00:00
 *
 * @author zhaojianwei
 * @since JDK 1.8
 */
public class GmeiKafkaSource {
    private String topic;
    private Properties prop;
    private FlinkKafkaConsumer flinkKafkaConsumer;

    public GmeiKafkaSource(String topic) {
        this.topic = topic;
        this.prop = new Properties();
    }

    public void setSource(DeserializationSchema<String> schema) throws ParseException {
        this.flinkKafkaConsumer = new FlinkKafkaConsumer<String>(topic,schema,this.prop);
    }

    public FlinkKafkaConsumer getSource(){
        return this.flinkKafkaConsumer;
    }

    public void setProp(String key,String value){
        prop.setProperty(key,value);
    }
}
