package com.gmei.data.ctr.source;

import com.alibaba.druid.pool.DruidDataSource;
import com.gmei.data.ctr.bean.CtrEstimateTagEtl;
import com.gmei.data.ctr.bean.DeviceCurrentEstimateTagTmp;
import com.gmei.data.ctr.common.Constants;
import com.gmei.data.ctr.utils.DateUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.async.ResultFuture;
import org.apache.flink.streaming.api.functions.async.RichAsyncFunction;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Collections;
import java.util.Date;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.Supplier;

import static java.util.concurrent.Executors.newFixedThreadPool;

/**
 * @ClassName MysqlAsyncSource
 * @Author apple
 * @Date 2020/3/29
 * @Version V1.0
 **/
public class TidbMysqlAsyncTagSource extends RichAsyncFunction<CtrEstimateTagEtl, DeviceCurrentEstimateTagTmp> {
    private String jerryJdbcUrl;
    private String jerryUsername;
    private String jerryPassword;
    private transient DruidDataSource dataSource;
    private transient ExecutorService executorService;

    public TidbMysqlAsyncTagSource(String jerryJdbcUrl, String jerryUsername, String jerryPassword) {
        this.jerryJdbcUrl = jerryJdbcUrl;
        this.jerryUsername = jerryUsername;
        this.jerryPassword = jerryPassword;
    }

    @Override
    public void open(Configuration parameters) throws Exception {
        super.open(parameters);
        executorService = newFixedThreadPool(20);
        dataSource = new DruidDataSource();
        dataSource.setDriverClassName(Constants.MYSQL_DRIVER_CLASS);
        dataSource.setUrl(jerryJdbcUrl);
        dataSource.setUsername(jerryUsername);
        dataSource.setPassword(jerryPassword);

        dataSource.setInitialSize(5);
        dataSource.setMinIdle(10);
        dataSource.setMaxActive(20);
    }

    @Override
    public void asyncInvoke(CtrEstimateTagEtl ctrEstimateTagEtl, ResultFuture<DeviceCurrentEstimateTagTmp> resultFuture) throws Exception {
        Future<DeviceCurrentEstimateTagTmp> future = executorService.submit(() -> {
            return queryFromMySql(ctrEstimateTagEtl);
        });
        CompletableFuture.supplyAsync(new Supplier<DeviceCurrentEstimateTagTmp>() {
            @Override
            public DeviceCurrentEstimateTagTmp get() {
                try {
                    return future.get();
                } catch (Exception e) {
                    return null;
                }
            }
        }).thenAccept((DeviceCurrentEstimateTagTmp dbResult) ->{
            resultFuture.complete(Collections.singleton(dbResult));
        });
    }

    private DeviceCurrentEstimateTagTmp queryFromMySql(CtrEstimateTagEtl ctrEstimateTagEtl)  {
        DeviceCurrentEstimateTagTmp dcett = null;
        String type = ctrEstimateTagEtl.getType();
        if("commodity".equals(type) || "content".equals(type)){
            String sql = null;
            String cardContentType = ctrEstimateTagEtl.getCardContentType();
            Long cardId = ctrEstimateTagEtl.getCardId();
            if("commodity".equals(type) && "service".equals(cardContentType)){
                sql = String.format("select first_demands,first_positions,first_solutions,second_demands,second_positions,second_solutions,project_tags " +
                        "from strategy_service_tagv3_info where service_id = '%d'",cardId);
            }
            if("content".equals(type)){
                if("diary".equals(cardContentType)){
                    sql = String.format("select first_demands,first_positions,first_solutions,second_demands,second_positions,second_solutions,project_tags " +
                            "from strategy_content_tagv3_info where content_id = '%d'",cardId);
                }else if("tractate".equals(cardContentType)){
                    sql = String.format("select first_demands,first_positions,first_solutions,second_demands,second_positions,second_solutions,project_tags " +
                            "from strategy_tractate_tagv3_info where content_id = '%d'",cardId);
                }else if("answer".equals(cardContentType)){
                    sql = String.format("select first_demands,first_positions,first_solutions,second_demands,second_positions,second_solutions,project_tags " +
                            "from strategy_answer_tagv3_info where content_id = '%d'",cardId);
                }
            }
            if(StringUtils.isNotBlank(sql)){
                dcett = findTagInfo(sql);
                if(null != dcett){
                    Date date = new Date();
                    dcett.setType(type);
                    dcett.setDeviceId(ctrEstimateTagEtl.getDeviceId());
                    dcett.setPartitionDate(DateUtils.getDateStr(date));
                    dcett.setLastUpdateTime(DateUtils.getTimeStr(date));
                }
            }
        }
        return dcett;
    }

    private DeviceCurrentEstimateTagTmp findTagInfo(String sql){
        DeviceCurrentEstimateTagTmp deviceCurrentEstimateTagTmp = null;
        Connection connection = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            connection = dataSource.getConnection();
            stmt = connection.prepareStatement(sql);
            rs = stmt.executeQuery();
            while(rs.next()){
                deviceCurrentEstimateTagTmp = new DeviceCurrentEstimateTagTmp();
                deviceCurrentEstimateTagTmp.setProject(rs.getString("project_tags"));
                deviceCurrentEstimateTagTmp.setFirstDemands(rs.getString("first_demands"));
                deviceCurrentEstimateTagTmp.setFirstPositions(rs.getString("first_positions"));
                deviceCurrentEstimateTagTmp.setFirstSolutions(rs.getString("first_solutions"));
                deviceCurrentEstimateTagTmp.setSecondDemands(rs.getString("second_demands"));
                deviceCurrentEstimateTagTmp.setSecondPositions(rs.getString("second_positions"));
                deviceCurrentEstimateTagTmp.setSecondSolutions(rs.getString("second_solutions"));
            }
        } catch (Exception e){
            e.printStackTrace();
        }finally {
            try{
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }catch (Exception e){
                e.printStackTrace();
            }
        }
        return deviceCurrentEstimateTagTmp;
    }

    @Override
    public void close() {
        dataSource.close();
        executorService.shutdown();
    }
}