package com.gmei.data.ctr.sink;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.gmei.data.ctr.bean.CtrPfrCrtBean;
import com.gmei.data.ctr.bean.CtrPfrRctBean;
import com.gmei.data.ctr.bean.PfrRecent10QueueBean;
import com.gmei.data.ctr.bean.PfrRecentInfo;
import com.gmei.data.ctr.common.Constants;
import com.gmei.data.ctr.utils.DateUtil;
import com.gmei.data.ctr.utils.JDBCUtil;
import com.gmei.data.ctr.utils.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.functions.sink.RichSinkFunction;
import org.apache.flink.table.planner.expressions.In;

import java.sql.*;
import java.util.*;
import java.util.Date;

/**
 * @ClassName CtrEstimatePfrMysqlSink
 * @Description: CTR特征预估偏好MysqlSink
 * @Author zhaojianwei
 * @Date 2020/3/31
 * @Version V1.0
 **/
public class CtrPfrRctMysqlSink extends RichSinkFunction<CtrPfrRctBean> {
    private int maxRetry;
    private long retryInteral;
    private String jdbcUrl;
    private Connection connection;
    public CtrPfrRctMysqlSink(String jdbcUrl, int maxRetry, long retryInteral) {
        this.jdbcUrl = jdbcUrl;
        this.maxRetry = maxRetry;
        this.retryInteral = retryInteral;
    }
    @Override
    public void open(Configuration parameters) throws Exception {
        Class.forName(Constants.MYSQL_DRIVER_CLASS);
        connection = DriverManager.getConnection(jdbcUrl);
        super.open(parameters);
    }
    @Override
    public void invoke(CtrPfrRctBean ctrPfrRctBean, Context context) throws Exception {
        try {
            insertAndDel(ctrPfrRctBean);
        }catch (Exception e){
            e.printStackTrace();
            int numReties = 1;
            Exception lastException = e;
            while (numReties <= maxRetry){
                try {
                    numReties++;
                    Thread.sleep(retryInteral);
                    insertAndDel(ctrPfrRctBean);
                }catch (Exception e1){
                    lastException = e1;
                    continue;
                }
                return;
            }
            throw lastException;
        }
    }
    @Override
    public void close() throws Exception {
        JDBCUtil.close(connection,null,null);
        super.close();
    }

    private void insertAndDel(CtrPfrRctBean ctrPfrRctBean)  {
        if(null != ctrPfrRctBean){
            Statement statement = null;
            Date date = new Date();
            String timeStr = DateUtil.getTimeStr(date);
            String deviceId = ctrPfrRctBean.getDeviceId();
            String statisticsType = ctrPfrRctBean.getStatisticsType();
            String statisticsTypeId = ctrPfrRctBean.getStatisticsTypeId();
            String projectPfr = ctrPfrRctBean.getProjectPfr();
            String firstDemandsPfr = ctrPfrRctBean.getFirstDemandsPfr();
            String firstPositionsPfr = ctrPfrRctBean.getFirstPositionsPfr();
            String firstSolutionsPfr = ctrPfrRctBean.getFirstSolutionsPfr();
            String secondDemandsPfr = ctrPfrRctBean.getSecondDemandsPfr();
            String secondPositionsPfr = ctrPfrRctBean.getSecondPositionsPfr();
            String secondSolutionsPfr = ctrPfrRctBean.getSecondSolutionsPfr();
            if(null != ctrPfrRctBean){
                boolean isExist = false;
                String pfrRecent10QueueInfo="";
                PfrRecent10QueueBean pfrRecent10QueueBean = null;
                try{
                    statement = connection.createStatement();
                    ResultSet resultSet = statement.executeQuery(
                            String.format(
                                    "select " +
                                            "pfr_recent10_queue_info " +
                                            "from device_recently_estimate_view_pfr_new " +
                                            "where device_id = '%s' and statistics_type = '%s' and statistics_type_id = '%s'",
                                    ctrPfrRctBean.getDeviceId(),
                                    ctrPfrRctBean.getStatisticsType(),
                                    ctrPfrRctBean.getStatisticsTypeId()
                            )
                    );
                    // 获取各子属性的值
                    String projectPfrRecentInit = StringUtil.transString2PairedString(projectPfr);
                    String firstDemandsPfrRecentInit = StringUtil.transString2PairedString(firstDemandsPfr);
                    String firstPositionsPfrRecentInit = StringUtil.transString2PairedString(firstPositionsPfr);
                    String firstSolutionsPfrRecentInit = StringUtil.transString2PairedString(firstSolutionsPfr);
                    String secondDemandsPfrRecentInit = StringUtil.transString2PairedString(secondDemandsPfr);
                    String secondPositionsPfrRecentInit = StringUtil.transString2PairedString(secondPositionsPfr);
                    String secondSolutionsPfrRecentInit = StringUtil.transString2PairedString(secondSolutionsPfr);
                    if (resultSet.next()){
                        isExist = true;
                        pfrRecent10QueueInfo=resultSet.getString("pfr_recent10_queue_info");
                        pfrRecent10QueueBean = JSON.parseObject(pfrRecent10QueueInfo, PfrRecent10QueueBean.class);
                    }
                    if(isExist){
                        LinkedList<PfrRecentInfo> projectPfrQueue3 = getNewQueue(pfrRecent10QueueBean.getProjectPfrQueue(),projectPfr,timeStr,3);
                        LinkedList<PfrRecentInfo> firstDemandsPfrQueue3 = getNewQueue(pfrRecent10QueueBean.getFirstDemandsPfrQueue(),firstDemandsPfr,timeStr,3);
                        LinkedList<PfrRecentInfo> firstPositionsPfrQueue3 = getNewQueue(pfrRecent10QueueBean.getFirstPositionsPfrQueue(),firstPositionsPfr,timeStr,3);
                        LinkedList<PfrRecentInfo> firstSolutionsPfrQueue3 = getNewQueue(pfrRecent10QueueBean.getFirstSolutionsPfrQueue(),firstSolutionsPfr,timeStr,3);
                        LinkedList<PfrRecentInfo> secondDemandsPfrQueue3 = getNewQueue(pfrRecent10QueueBean.getSecondDemandsPfrQueue(),secondDemandsPfr,timeStr,3);
                        LinkedList<PfrRecentInfo> secondPositionsPfrQueue3 = getNewQueue(pfrRecent10QueueBean.getSecondPositionsPfrQueue(),secondPositionsPfr,timeStr,3);
                        LinkedList<PfrRecentInfo> secondSolutionsPfrQueue3 = getNewQueue(pfrRecent10QueueBean.getSecondSolutionsPfrQueue(),secondSolutionsPfr,timeStr,3);

                        LinkedList<PfrRecentInfo> projectPfrQueue10 = getNewQueue(pfrRecent10QueueBean.getProjectPfrQueue(),projectPfr,timeStr,10);
                        LinkedList<PfrRecentInfo> firstDemandsPfrQueue10 = getNewQueue(pfrRecent10QueueBean.getFirstDemandsPfrQueue(),firstDemandsPfr,timeStr,10);
                        LinkedList<PfrRecentInfo> firstPositionsPfrQueue10 = getNewQueue(pfrRecent10QueueBean.getFirstPositionsPfrQueue(),firstPositionsPfr,timeStr,10);
                        LinkedList<PfrRecentInfo> firstSolutionsPfrQueue10 = getNewQueue(pfrRecent10QueueBean.getFirstSolutionsPfrQueue(),firstSolutionsPfr,timeStr,10);
                        LinkedList<PfrRecentInfo> secondDemandsPfrQueue10 = getNewQueue(pfrRecent10QueueBean.getSecondDemandsPfrQueue(),secondDemandsPfr,timeStr,10);
                        LinkedList<PfrRecentInfo> secondPositionsPfrQueue10 = getNewQueue(pfrRecent10QueueBean.getSecondPositionsPfrQueue(),secondPositionsPfr,timeStr,10);
                        LinkedList<PfrRecentInfo> secondSolutionsPfrQueue10 = getNewQueue(pfrRecent10QueueBean.getSecondSolutionsPfrQueue(),secondSolutionsPfr,timeStr,10);

                        String projectPfrRecent3 = StringUtil.transPfrRecentInfoList2String(projectPfrQueue3);
                        String firstDemandsPfrRecent3 = StringUtil.transPfrRecentInfoList2String(firstDemandsPfrQueue3);
                        String firstPositionsPfrRecent3 = StringUtil.transPfrRecentInfoList2String(firstPositionsPfrQueue3);
                        String firstSolutionsPfrRecent3 = StringUtil.transPfrRecentInfoList2String(firstSolutionsPfrQueue3);
                        String secondDemandsPfrRecent3 = StringUtil.transPfrRecentInfoList2String(secondDemandsPfrQueue3);
                        String secondPositionsPfrRecent3 = StringUtil.transPfrRecentInfoList2String(secondPositionsPfrQueue3);
                        String secondSolutionsPfrRecent3 = StringUtil.transPfrRecentInfoList2String(secondSolutionsPfrQueue3);

                        String projectPfrRecent10 = StringUtil.transPfrRecentInfoList2String(projectPfrQueue10);
                        String firstDemandsPfrRecent10 = StringUtil.transPfrRecentInfoList2String(firstDemandsPfrQueue10);
                        String firstPositionsPfrRecent10 = StringUtil.transPfrRecentInfoList2String(firstPositionsPfrQueue10);
                        String firstSolutionsPfrRecent10 = StringUtil.transPfrRecentInfoList2String(firstSolutionsPfrQueue10);
                        String secondDemandsPfrRecent10 = StringUtil.transPfrRecentInfoList2String(secondDemandsPfrQueue10);
                        String secondPositionsPfrRecent10 = StringUtil.transPfrRecentInfoList2String(secondPositionsPfrQueue10);
                        String secondSolutionsPfrRecent10 = StringUtil.transPfrRecentInfoList2String(secondSolutionsPfrQueue10);

                        pfrRecent10QueueBean = new PfrRecent10QueueBean(
                                deviceId,
                                statisticsType,
                                statisticsTypeId,
                                projectPfrQueue10,
                                firstDemandsPfrQueue10,
                                firstPositionsPfrQueue10,
                                firstSolutionsPfrQueue10,
                                secondDemandsPfrQueue10,
                                secondPositionsPfrQueue10,
                                secondSolutionsPfrQueue10,
                                timeStr
                        );
                        pfrRecent10QueueInfo = JSONObject.toJSONString(pfrRecent10QueueBean);

                        statement.executeUpdate(
                                String.format(
                                        "update device_recently_estimate_view_pfr_new set "+
                                                "project_pfr_recent1 = '%s'," +
                                                "project_pfr_recent3 = '%s'," +
                                                "project_pfr_recent10 = '%s'," +
                                                "first_demands_pfr_recent1 = '%s'," +
                                                "first_demands_pfr_recent3 = '%s'," +
                                                "first_demands_pfr_recent10 = '%s'," +
                                                "first_positions_pfr_recent1 = '%s'," +
                                                "first_positions_pfr_recent3 = '%s'," +
                                                "first_positions_pfr_recent10 = '%s'," +
                                                "first_solutions_pfr_recent1 = '%s'," +
                                                "first_solutions_pfr_recent3 = '%s'," +
                                                "first_solutions_pfr_recent10 = '%s'," +
                                                "second_demands_pfr_recent1 = '%s'," +
                                                "second_demands_pfr_recent3 = '%s'," +
                                                "second_demands_pfr_recent10 = '%s'," +
                                                "second_positions_pfr_recent1 = '%s'," +
                                                "second_positions_pfr_recent3 = '%s'," +
                                                "second_positions_pfr_recent10 = '%s'," +
                                                "second_solutions_pfr_recent1 = '%s'," +
                                                "second_solutions_pfr_recent3 = '%s'," +
                                                "second_solutions_pfr_recent10 = '%s'," +
                                                "pfr_recent10_queue_info = '%s'," +
                                                "last_update_time = '%s' " +
                                                "where device_id = '%s' and statistics_type = '%s' and statistics_type_id = '%s'",
                                        projectPfrRecentInit,
                                        projectPfrRecent3,
                                        projectPfrRecent10,
                                        firstDemandsPfrRecentInit,
                                        firstDemandsPfrRecent3,
                                        firstDemandsPfrRecent10,
                                        firstPositionsPfrRecentInit,
                                        firstPositionsPfrRecent3,
                                        firstPositionsPfrRecent10,
                                        firstSolutionsPfrRecentInit,
                                        firstSolutionsPfrRecent3,
                                        firstSolutionsPfrRecent10,
                                        secondDemandsPfrRecentInit,
                                        secondDemandsPfrRecent3,
                                        secondDemandsPfrRecent10,
                                        secondPositionsPfrRecentInit,
                                        secondPositionsPfrRecent3,
                                        secondPositionsPfrRecent10,
                                        secondSolutionsPfrRecentInit,
                                        secondSolutionsPfrRecent3,
                                        secondSolutionsPfrRecent10,
                                        pfrRecent10QueueInfo,
                                        DateUtil.getTimeStr(date),
                                        ctrPfrRctBean.getDeviceId(),
                                        ctrPfrRctBean.getStatisticsType(),
                                        ctrPfrRctBean.getStatisticsTypeId(),
                                        DateUtil.getDateStr(date)
                                )
                        );
                    }else{
                        // 获取队列属性的值
                        LinkedList<PfrRecentInfo> projectPfrQueue = StringUtil.transString2PfrRecentInfoList(projectPfr,timeStr);
                        LinkedList<PfrRecentInfo> firstDemandsPfrQueue = StringUtil.transString2PfrRecentInfoList(firstDemandsPfr,timeStr);
                        LinkedList<PfrRecentInfo> firstPositionsPfrQueue = StringUtil.transString2PfrRecentInfoList(firstPositionsPfr,timeStr);
                        LinkedList<PfrRecentInfo> firstSolutionsPfrQueue = StringUtil.transString2PfrRecentInfoList(firstSolutionsPfr,timeStr);
                        LinkedList<PfrRecentInfo> secondDemandsPfrQueue = StringUtil.transString2PfrRecentInfoList(secondDemandsPfr,timeStr);
                        LinkedList<PfrRecentInfo> secondPositionsPfrQueue = StringUtil.transString2PfrRecentInfoList(secondPositionsPfr,timeStr);
                        LinkedList<PfrRecentInfo> secondSolutionsPfrQueue = StringUtil.transString2PfrRecentInfoList(secondSolutionsPfr,timeStr);
                        pfrRecent10QueueBean = new PfrRecent10QueueBean(
                                deviceId,
                                statisticsType,
                                statisticsTypeId,
                                projectPfrQueue,
                                firstDemandsPfrQueue,
                                firstPositionsPfrQueue,
                                firstSolutionsPfrQueue,
                                secondDemandsPfrQueue,
                                secondPositionsPfrQueue,
                                secondSolutionsPfrQueue,
                                timeStr
                        );
                        pfrRecent10QueueInfo = JSONObject.toJSONString(pfrRecent10QueueBean);
                        // 执行插入操作
                        statement.executeUpdate(
                                String.format(
                                        "insert into device_recently_estimate_view_pfr_new("+
                                                "device_id," +
                                                "statistics_type," +
                                                "statistics_type_id," +
                                                "project_pfr_recent1," +
                                                "project_pfr_recent3," +
                                                "project_pfr_recent10," +
                                                "first_demands_pfr_recent1," +
                                                "first_demands_pfr_recent3," +
                                                "first_demands_pfr_recent10," +
                                                "first_positions_pfr_recent1," +
                                                "first_positions_pfr_recent3," +
                                                "first_positions_pfr_recent10," +
                                                "first_solutions_pfr_recent1," +
                                                "first_solutions_pfr_recent3," +
                                                "first_solutions_pfr_recent10," +
                                                "second_demands_pfr_recent1," +
                                                "second_demands_pfr_recent3," +
                                                "second_demands_pfr_recent10," +
                                                "second_positions_pfr_recent1," +
                                                "second_positions_pfr_recent3," +
                                                "second_positions_pfr_recent10," +
                                                "second_solutions_pfr_recent1," +
                                                "second_solutions_pfr_recent3," +
                                                "second_solutions_pfr_recent10," +
                                                "pfr_recent10_queue_info," +
                                                "last_update_time," +
                                                ") values ('%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s'," +
                                                "'%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s')",
                                        deviceId,
                                        statisticsType,
                                        statisticsTypeId,
                                        projectPfrRecentInit,
                                        projectPfrRecentInit,
                                        projectPfrRecentInit,
                                        firstDemandsPfrRecentInit,
                                        firstDemandsPfrRecentInit,
                                        firstDemandsPfrRecentInit,
                                        firstPositionsPfrRecentInit,
                                        firstPositionsPfrRecentInit,
                                        firstPositionsPfrRecentInit,
                                        firstSolutionsPfrRecentInit,
                                        firstSolutionsPfrRecentInit,
                                        firstSolutionsPfrRecentInit,
                                        secondDemandsPfrRecentInit,
                                        secondDemandsPfrRecentInit,
                                        secondDemandsPfrRecentInit,
                                        secondPositionsPfrRecentInit,
                                        secondPositionsPfrRecentInit,
                                        secondPositionsPfrRecentInit,
                                        secondSolutionsPfrRecentInit,
                                        secondSolutionsPfrRecentInit,
                                        secondSolutionsPfrRecentInit,
                                        pfrRecent10QueueInfo,
                                        DateUtil.getTimeStr(date)
                                )
                        );
                    }
                    JDBCUtil.close(null,statement,null);
                }catch (Exception e){
                    e.printStackTrace();
                }
            }
        }
    }

    private LinkedList<PfrRecentInfo> getNewQueue(LinkedList<PfrRecentInfo> oldQueue, String pfrStr, String timeStr, Integer queueSize ){
        LinkedList<PfrRecentInfo> newQueue = new LinkedList<>();
        Map<String,Integer> pfrMap = StringUtil.transString2Map(pfrStr);
        for (PfrRecentInfo pfrRecentInfo : oldQueue) {
            String pfrName = pfrRecentInfo.getPfrName();
            Integer pfrCount = pfrRecentInfo.getPfrCount();
            if(pfrMap.keySet().contains(pfrName)){
                newQueue.add(new PfrRecentInfo(pfrName,pfrCount + 1 ,timeStr));
            }else{
                newQueue.add(pfrRecentInfo);
            }
        }
        while(newQueue.size() > queueSize){
            Collections.sort(newQueue);
            newQueue.removeLast();
        }
        return newQueue;
    }
}
