#!/bin/bash

export FLINK_HOME=/opt/flink-1.9.0
export JAR_DIR=/srv/apps/ctr-estimate/libs
export HADOOP_HOME=/opt/hadoop-2.6.0-cdh5.16.1
export JAVA_OPTS="-Xms1024m -Xmx8192m -XX:-UseGCOverheadLimit -XX:+UseConcMarkSweepGC"

nohup $FLINK_HOME/bin/flink run  \
-m yarn-cluster \
-ynm ctr-estimate-tag-crt \
-yqu hadoop \
-yn 2 \
-ys 2 \
-p 6 \
-yjm 1024 \
-ytm 2048 \
-c com.gmei.data.ctr.main.ProdCtrTagCrtMain \
$JAR_DIR/ctr-estimate-1.0-SNAPSHOT.jar \
--inBrokers '172.16.44.25:9092,172.16.44.31:9092,172.16.44.45:9092' \
--batchSize 1000 \
--maidianInTopic 'gm-maidian-data' \
--maidianInGroupId 'ctr-estimate-tag-crt' \
--windowSize 5 \
--slideSize 5 \
--outJdbcUrl 'jdbc:mysql://172.16.40.170:4000/jerry_test?user=data_user&password=YPEzp78HQBuhByWPpefQu6X3D6hEPfD6&autoReconnect=true&useSSL=false' \
--maxRetry 3 \
--retryInteral 3000 \
--checkpointPath 'hdfs://bj-gmei-hdfs/user/data/flink/ctr-estimate-tag-crt/checkpoint' \
--parallelism 6 \
>> /data/log/ctr-estimate/ctr-estimate-tag-crt.out 2>&1 &

tail -f /data/log/ctr-estimate/ctr-estimate-tag-crt.out