-- CREATE SCHEMA `jerry_test` DEFAULT CHARACTER SET utf8mb4 ;
use jerry_test;

-- CTR特征预估点击量表
CREATE TABLE `device_current_estimate_clk` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `device_id` varchar(150) DEFAULT NULL COMMENT '设备ID',
  `content_card_click` bigint(20) DEFAULT NULL COMMENT '日记贴点击量',
  `tractate_card_click` bigint(20) DEFAULT NULL COMMENT '用户贴点击量',
  `answer_card_click` bigint(20) DEFAULT NULL COMMENT '问答贴点击量',
  `partition_date` varchar(45) DEFAULT NULL COMMENT '日期',
  `last_update_time` varchar(45) DEFAULT NULL COMMENT '上一次更改的时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- CTR特征预估标签平台表
CREATE TABLE `device_current_estimate_tag_plat` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `device_id` varchar(150) DEFAULT NULL COMMENT '设备ID',
  `plat_first_positions` text COMMENT '当日平台一级部位偏好',
  `plat_first_solutions` text COMMENT '当日平台一级方式偏好',
  `plat_first_demands` text COMMENT '当日平台项目偏好',
  `plat_project` text COMMENT '当日平台一级诉求偏好',
  `plat_second_positions` text COMMENT '当日平台二级部位偏好',
  `plat_second_solutions` text COMMENT '当日平台二级方式偏好',
  `plat_second_demands` text COMMENT '当日平台二级诉求偏好',
  `partition_date` varchar(45) DEFAULT NULL COMMENT '日期',
  `last_update_time` varchar(45) DEFAULT NULL COMMENT '上一次更改的时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- CTR特征预估标签非平台表
CREATE TABLE `device_current_estimate_tag_unplat` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `device_id` varchar(150) DEFAULT NULL COMMENT '设备ID',
  `commodity_project` text COMMENT '当日内容项目偏好',
  `commodity_first_demands` text COMMENT '当日内容一级诉求偏好',
  `commodity_first_positions` text COMMENT '当日商品一级部位偏好',
  `commodity_first_solutions` text COMMENT '当日商品一级方式偏好',
  `commodity_second_demands` text COMMENT '当日商品二级诉求偏好',
  `commodity_second_positions` text COMMENT '当日商品二级部位偏好',
  `commodity_second_solutions` text COMMENT '当日商品二级方式偏好',
  `content_project` text COMMENT '当日内容项目偏好',
  `content_first_demands` text COMMENT '当日内容一级诉求偏好',
  `content_first_positions` text COMMENT '当日内容一级部位偏好',
  `content_first_solutions` text COMMENT '当日内容一级方式偏好',
  `content_second_demands` text COMMENT '当日内容二级诉求偏好',
  `content_second_positions` text COMMENT '当日内容二级部位偏好',
  `content_second_solutions` text COMMENT '当日内容二级方式偏好',
  `partition_date` varchar(45) DEFAULT NULL COMMENT '日期',
  `last_update_time` varchar(45) DEFAULT NULL COMMENT '上一次更改的时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- CTR特征预估最近偏好表
CREATE TABLE `device_recently_estimate_view_pfr_new` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `device_id` varchar(150) DEFAULT NULL COMMENT '设备ID',
  `statistics_type` varchar(150) DEFAULT NULL COMMENT '统计类型',
  `statistics_type_id` varchar(150) DEFAULT NULL COMMENT '统计类型id',
  `project_pfr_recent1` text COMMENT '近一次项目偏好(去重后)',
  `project_pfr_recent3` text COMMENT '近三次项目偏好(去重后)',
  `project_pfr_recent10` text COMMENT '近十次项目偏好(去重后)',
  `first_demands_pfr_recent1` text COMMENT '近一次一级诉求偏好(偏好去重，次数累加) eg: (xx:a,yy:b,zz:c)',
  `first_demands_pfr_recent3` text COMMENT '近三次一级诉求偏好(偏好去重，次数累加) eg: (xx:a,yy:b,zz:c)',
  `first_demands_pfr_recent10` text COMMENT '近十次一级诉求偏好(偏好去重，次数累加) eg: (xx:a,yy:b,zz:c)',
  `first_positions_pfr_recent1` text COMMENT '近一次一级部位偏好(偏好去重，次数累加) eg: (xx:a,yy:b,zz:c)',
  `first_positions_pfr_recent3` text COMMENT '近三次一级部位偏好(偏好去重，次数累加) eg: (xx:a,yy:b,zz:c)',
  `first_positions_pfr_recent10` text COMMENT '近十次一级部位偏好(偏好去重，次数累加) eg: (xx:a,yy:b,zz:c)',
  `first_solutions_pfr_recent1` text COMMENT '近一次一级方式偏好(偏好去重，次数累加) eg: (xx:a,yy:b,zz:c)',
  `first_solutions_pfr_recent3` text COMMENT '近三次一级方式偏好(偏好去重，次数累加) eg: (xx:a,yy:b,zz:c)',
  `first_solutions_pfr_recent10` text COMMENT '近十次一级方式偏好(偏好去重，次数累加) eg: (xx:a,yy:b,zz:c)',
  `second_demands_pfr_recent1` text COMMENT '近一次二级诉求偏好(偏好去重，次数累加) eg: (xx:a,yy:b,zz:c)',
  `second_demands_pfr_recent3` text COMMENT '近三次二级诉求偏好(偏好去重，次数累加) eg: (xx:a,yy:b,zz:c)',
  `second_demands_pfr_recent10` text COMMENT '近十次二级诉求偏好(偏好去重，次数累加) eg: (xx:a,yy:b,zz:c)',
  `second_positions_pfr_recent1` text COMMENT '近一次二级部位偏好(偏好去重，次数累加) eg: (xx:a,yy:b,zz:c)',
  `second_positions_pfr_recent3` text COMMENT '近三次二级部位偏好(偏好去重，次数累加) eg: (xx:a,yy:b,zz:c)',
  `second_positions_pfr_recent10` text COMMENT '近十次二级部位偏好(偏好去重，次数累加) eg: (xx:a,yy:b,zz:c)',
  `second_solutions_pfr_recent1` text COMMENT '近一次二级方式偏好(偏好去重，次数累加) eg: (xx:a,yy:b,zz:c)',
  `second_solutions_pfr_recent3` text COMMENT '近三次二级方式偏好(偏好去重，次数累加) eg: (xx:a,yy:b,zz:c)',
  `second_solutions_pfr_recent10` text COMMENT '近十次二级方式偏好(偏好去重，次数累加) eg: (xx:a,yy:b,zz:c)',
  `last_update_time` varchar(45) DEFAULT NULL COMMENT '上一次更改的时间',
 PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- CTR特征预估当日偏好表
CREATE TABLE `device_current_estimate_view_pfr_new` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `device_id` varchar(150) DEFAULT NULL COMMENT '设备ID',
  `statistics_type` varchar(150) DEFAULT NULL COMMENT '统计类型',
  `statistics_type_id` varchar(150) DEFAULT NULL COMMENT '统计类型id',
  `project_pfr` text COMMENT '项目偏好,当天次数累加、偏好去重 eg: (xx:a,yy:b,zz:c)',
  `first_demands_pfr` text COMMENT '一级诉求偏好,当天次数累加、偏好去重 eg: (xx:a,yy:b,zz:c)',
  `first_positions_pfr` text COMMENT '一级部位偏好,当天次数累加、偏好去重 eg: (xx:a,yy:b,zz:c)',
  `first_solutions_pfr` text COMMENT '一级方式偏好,当天次数累加、偏好去重 eg: (xx:a,yy:b,zz:c)',
  `second_demands_pfr` text COMMENT '二级诉求偏好,当天次数累加、偏好去重 eg: (xx:a,yy:b,zz:c)',
  `second_positions_pfr` text COMMENT '二级部位偏好,当天次数累加、偏好去重 eg: (xx:a,yy:b,zz:c)',
  `second_solutions_pfr` text COMMENT '二级方式偏好,当天次数累加、偏好去重 eg: (xx:a,yy:b,zz:c)',
  `partition_date` varchar(45) DEFAULT NULL COMMENT '日期',
  `last_update_time` varchar(45) DEFAULT NULL COMMENT '上一次更改的时间',
PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;











































-- CTR特征预估点击量表
# CREATE TABLE `device_current_estimate_clk` (
#    `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
#    `device_id` varchar(150) DEFAULT NULL COMMENT '设备ID',
#    `content_card_click` bigint(20) DEFAULT NULL COMMENT '日记贴点击量',
#    `tractate_card_click` bigint(20) DEFAULT NULL COMMENT '用户贴点击量',
#    `answer_card_click` bigint(20) DEFAULT NULL COMMENT '问答贴点击量',
#    `like_diary_count` bigint(20) DEFAULT NULL COMMENT '点赞日记数量',
#    `like_card_count` bigint(20) DEFAULT NULL COMMENT '点赞帖子数量',
#    `like_answer_count` bigint(20) DEFAULT NULL COMMENT '点赞回答数量',
#    `discuss_diary_count` bigint(20) DEFAULT NULL COMMENT '评论日记数量',
#    `discuss_card_count` bigint(20) DEFAULT NULL COMMENT '评论帖子数量',
#    `discuss_answer_count` bigint(20) DEFAULT NULL COMMENT '评论回答数量',
#    `collect_diary_count` bigint(20) DEFAULT NULL COMMENT '收藏日记数量',
#    `collect_card_count` bigint(20) DEFAULT NULL COMMENT '收藏帖子数量',
#    `collect_answer_count` bigint(20) DEFAULT NULL COMMENT '收藏问答数量',
#    `partition_date` varchar(45) DEFAULT NULL COMMENT '日期',
#    `last_update_time` varchar(45) DEFAULT NULL COMMENT '上一次更改的时间',
#    PRIMARY KEY (`id`)
# ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- CTR特征预估标签表
# CREATE TABLE `device_current_estimate` (
#   `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
#   `device_id` varchar(150) DEFAULT NULL COMMENT '设备ID',
#   `content_card_click` bigint(20) DEFAULT NULL COMMENT '日记贴点击量',
#   `tractate_card_click` bigint(20) DEFAULT NULL COMMENT '用户贴点击量',
#   `answer_card_click` bigint(20) DEFAULT NULL COMMENT '问答贴点击量',
#   `plat_first_positions` text COMMENT '当日平台一级部位偏好',
#   `plat_first_solutions` text COMMENT '当日平台一级方式偏好',
#   `plat_first_demands` text COMMENT '当日平台项目偏好',
#   `plat_project` text COMMENT '当日平台一级诉求偏好',
#   `content_first_positions` text COMMENT '当日内容一级部位偏好',
#   `content_first_solutions` text COMMENT '当日内容一级方式偏好',
#   `content_first_demands` text COMMENT '当日内容一级诉求偏好',
#   `content_project` text COMMENT '当日内容项目偏好',
#   `commodity_first_positions` text COMMENT '当日商品一级部位偏好',
#   `commodity_first_solutions` text COMMENT '当日商品一级方式偏好',
#   `commodity_first_demands` text COMMENT '当日内容一级诉求偏好',
#   `commodity_project` text COMMENT '当日内容项目偏好',
#   `plat_second_positions` text COMMENT '当日平台二级部位偏好',
#   `plat_second_solutions` text COMMENT '当日平台二级方式偏好',
#   `plat_second_demands` text COMMENT '当日平台二级诉求偏好',
#   `content_second_positions` text COMMENT '当日内容二级部位偏好',
#   `content_second_solutions` text COMMENT '当日内容二级方式偏好',
#   `content_second_demands` text COMMENT '当日内容二级诉求偏好',
#   `commodity_second_positions` text COMMENT '当日商品二级部位偏好',
#   `commodity_second_solutions` text COMMENT '当日商品二级方式偏好',
#   `commodity_second_demands` text COMMENT '当日商品二级诉求偏好',
#   `partition_date` varchar(45) DEFAULT NULL COMMENT '日期',
#   `last_update_time` varchar(45) DEFAULT NULL COMMENT '上一次更改的时间',
#   PRIMARY KEY (`id`)
# ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;