package com.gmei.data.ctr.source;

import com.alibaba.druid.pool.DruidDataSource;
import com.gmei.data.ctr.bean.CtrTagCrtEtlBean;
import com.gmei.data.ctr.bean.CtrTagCrtTmpBean;
import com.gmei.data.ctr.common.Constants;
import com.gmei.data.ctr.utils.DateUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.async.ResultFuture;
import org.apache.flink.streaming.api.functions.async.RichAsyncFunction;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Collections;
import java.util.Date;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.Supplier;

import static java.util.concurrent.Executors.newFixedThreadPool;

/**
 * @ClassName MysqlAsyncSource
 * @Author apple
 * @Date 2020/3/29
 * @Version V1.0
 **/
public class ZxAsyncTagCrtSource extends RichAsyncFunction<CtrTagCrtEtlBean, CtrTagCrtTmpBean> {
    private String zxJdbcUrl;
    private String zxUsername;
    private String zxPassword;
    private transient DruidDataSource dataSource;
    private transient ExecutorService executorService;

    public ZxAsyncTagCrtSource(String zxJdbcUrl, String zxUsername, String zxPassword) {
        this.zxJdbcUrl = zxJdbcUrl;
        this.zxUsername = zxUsername;
        this.zxPassword = zxPassword;
    }

    @Override
    public void open(Configuration parameters) throws Exception {
        super.open(parameters);
        executorService = newFixedThreadPool(20);
        dataSource = new DruidDataSource();
        dataSource.setDriverClassName(Constants.MYSQL_DRIVER_CLASS);
        dataSource.setUrl(zxJdbcUrl);
        dataSource.setUsername(zxUsername);
        dataSource.setPassword(zxPassword);
        dataSource.setInitialSize(5);
        dataSource.setMinIdle(10);
        dataSource.setMaxActive(20);
    }
    @Override
    public void asyncInvoke(CtrTagCrtEtlBean ctrTagCrtEtlBean, ResultFuture<CtrTagCrtTmpBean> resultFuture) throws Exception {
        Future<CtrTagCrtTmpBean> future = executorService.submit(() -> {
            return queryFromMySql(ctrTagCrtEtlBean);
        });
        CompletableFuture.supplyAsync(new Supplier<CtrTagCrtTmpBean>() {
            @Override
            public CtrTagCrtTmpBean get() {
                try {
                    return future.get();
                } catch (Exception e) {
                    return null;
                }
            }
        }).thenAccept((CtrTagCrtTmpBean dbResult) ->{
            resultFuture.complete(Collections.singleton(dbResult));
        });
    }
    @Override
    public void close() throws Exception {
        dataSource.close();
        executorService.shutdown();
    }

    private boolean checkIsProjectInfo(String isProjectSql){
        boolean result = false;
        Connection connection = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            connection = dataSource.getConnection();
            stmt = connection.prepareStatement(isProjectSql);
            rs = stmt.executeQuery();
            while(rs.next()){
                result = true;
            }
        } catch (Exception e){
            e.printStackTrace();
        }finally {
            try{
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }catch (Exception e){
                e.printStackTrace();
            }
        }
        return result;
    }

    private CtrTagCrtTmpBean queryFromMySql(CtrTagCrtEtlBean ctrTagCrtEtlBean)  {
        CtrTagCrtTmpBean dcett = null;
        boolean isProjectInfo = false;
        String keyWord = ctrTagCrtEtlBean.getKeyWord();
        String isProjectSql = null;
        String sql = null;
        String type = ctrTagCrtEtlBean.getType();
        if("search".equals(type) && StringUtils.isNotBlank(keyWord)){
            isProjectSql = String.format("select * from api_tag_3_0 where name = '%s' and tag_type = '1'",keyWord);
            sql = String.format("select aggregate_type from api_tag_attr where id = (select tag_attr_id from api_tag_attr_tag where id = (select id from api_tag_3_0 " +
                    "where name = '%s'))",keyWord);
        }
        if(StringUtils.isNotBlank(isProjectSql)){
            isProjectInfo = checkIsProjectInfo(isProjectSql);
            if(isProjectInfo){
                dcett.setProject(keyWord);
            }else{
                dcett.setProject("");
            }
        }
        if(StringUtils.isNotBlank(sql)){
            dcett = findTagInfo(sql,keyWord);
            if(null != dcett){
                Date date = new Date();
                dcett.setType(type);
                dcett.setDeviceId(ctrTagCrtEtlBean.getDeviceId());
                dcett.setPartitionDate(DateUtils.getDateStr(date));
                dcett.setLastUpdateTime(DateUtils.getTimeStr(date));
            }
        }
        return dcett;
    }

    private CtrTagCrtTmpBean findTagInfo(String sql, String keyword){
        CtrTagCrtTmpBean ctrTagCrtTmpBean = null;
        Connection connection = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            connection = dataSource.getConnection();
            stmt = connection.prepareStatement(sql);
            rs = stmt.executeQuery();
            while(rs.next()){
                String aggregate_type = rs.getString("aggregate_type");
                if("7".equals(aggregate_type)){
                    ctrTagCrtTmpBean = new CtrTagCrtTmpBean();
                    ctrTagCrtTmpBean.setFirstDemands(keyword);
                }else if("10".equals(aggregate_type)){
                    ctrTagCrtTmpBean = new CtrTagCrtTmpBean();
                    ctrTagCrtTmpBean.setFirstPositions(keyword);
                }else if("6".equals(aggregate_type)){
                    ctrTagCrtTmpBean = new CtrTagCrtTmpBean();
                    ctrTagCrtTmpBean.setFirstSolutions(keyword);
                }else if("8".equals(aggregate_type)){
                    ctrTagCrtTmpBean = new CtrTagCrtTmpBean();
                    ctrTagCrtTmpBean.setSecondDemands(keyword);
                }else if("3".equals(aggregate_type)){
                    ctrTagCrtTmpBean = new CtrTagCrtTmpBean();
                    ctrTagCrtTmpBean.setSecondPositions(keyword);
                }else if("2".equals(aggregate_type)){
                    ctrTagCrtTmpBean = new CtrTagCrtTmpBean();
                    ctrTagCrtTmpBean.setFirstPositions(keyword);
                }
            }
        } catch (Exception e){
            e.printStackTrace();
        }finally {
            try{
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }catch (Exception e){
                e.printStackTrace();
            }
        }
        return ctrTagCrtTmpBean;
    }
}