package com.gmei.data.ctr.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

/**
 * @ClassName DateUtils
 * @Description: 时间工具类
 * @Author apple
 * @Date 2020/3/16
 * @Version V1.0
 **/
public class DateUtils {

    private static final String DATE_FORMATE_YMD = "yyyy-MM-dd";
    private static final String DATE_FORMATE_YMDHMS = "yyyy-MM-dd HH:mm:ss";

    /**
     * 获取当前日期字符串
     * @return
     */
    public static String getCurrentDateStr() {
        return new SimpleDateFormat(DATE_FORMATE_YMD).format(new Date());
    }

    /**
     * 获取当前时间字符串
     * @param date
     * @return
     */
    public static String getDateStr(Date date) {
        return new SimpleDateFormat(DATE_FORMATE_YMD).format(date);
    }

    public static String getTimeStr(Date date) {
        return new SimpleDateFormat(DATE_FORMATE_YMDHMS).format(date);
    }

    /**
     * 获取十分钟以前的时间字符串
     * @param date
     * @return
     */
    public static String getTenMinitesAgoTimeStr(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(Calendar.MINUTE,-10);
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMATE_YMDHMS);
        return sdf.format(calendar.getTime());
    }

    /**
     * 获取七天前的时间
     * @param date
     * @return
     */
    public static String getSevenDaysAgoTimeStr(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(Calendar.DAY_OF_MONTH,-7);
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMATE_YMDHMS);
        return sdf.format(calendar.getTime());
    }

    /**
     * 获取当前时间戳
     * @param date
     * @return
     */
    public static long getCurrentTimestamp(Date date) {
        return date.getTime();
    }

    /**
     * 获取十分钟以前的时间戳
     * @param date
     * @return
     */
    public static long getTenMinitesAgoTimestamp(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(Calendar.MINUTE,-10);
        return calendar.getTime().getTime();
    }

    /**
     * 根据时间字符串获得时间戳
     * @param dateStr
     * @return
     * @throws ParseException
     */
    public static Long getTimestampByDateStr(String dateStr) throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATE_FORMATE_YMDHMS);
        return simpleDateFormat.parse(dateStr).getTime();
    }

    /**
     * 将秒值转为指定格式的日期
     * @param second
     * @return
     */
    public static String secondToDate(long second) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(second * 1000);
        Date date = calendar.getTime();
        SimpleDateFormat format = new SimpleDateFormat(DATE_FORMATE_YMDHMS);
        String dateString = format.format(date);
        return dateString;
    }
}
