package com.gmei.data.ctr.sink;

import com.gmei.data.ctr.bean.DeviceCurrentEstimateClk;
import com.gmei.data.ctr.common.Constants;
import com.gmei.data.ctr.utils.JDBCUtils;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.sink.RichSinkFunction;

import java.sql.*;

/**
 * @ClassName CtrEstimateClkMysqlSink
 * @Description: CTR特征预估点击量MysqlSink
 * @Author zhaojianwei
 * @Date 2020/3/31
 * @Version V1.0
 **/
public class CtrEstimateClkMysqlSink extends RichSinkFunction<DeviceCurrentEstimateClk> {
    private String jdbcUrl;
    private int maxRetry;
    private long retryInteral;
    private Connection connection;
    public CtrEstimateClkMysqlSink(String jdbcUrl, int maxRetry, long retryInteral) {
        this.jdbcUrl = jdbcUrl;
        this.maxRetry = maxRetry;
        this.retryInteral = retryInteral;
    }
    @Override
    public void open(Configuration parameters) throws Exception {
        Class.forName(Constants.MYSQL_DRIVER_CLASS);
        connection = DriverManager.getConnection(jdbcUrl);
        super.open(parameters);
    }
    @Override
    public void invoke(DeviceCurrentEstimateClk deviceCurrentEstimateClk, Context context) throws Exception {
        try {
            insertOrUpdate(deviceCurrentEstimateClk);
        }catch (Exception e){
            e.printStackTrace();
            int numReties = 1;
            Exception lastException = e;
            while (numReties <= maxRetry){
                try {
                    numReties++;
                    Thread.sleep(retryInteral);
                    insertOrUpdate(deviceCurrentEstimateClk);
                }catch (Exception e1){
                    lastException = e1;
                    continue;
                }
                return;
            }
            throw lastException;
        }
    }
    @Override
    public void close() throws Exception {
        JDBCUtils.close(connection,null,null);
        super.close();
    }

    /**
     * 数据写入方法
     * @param deviceCurrentEstimateClk
     * @throws SQLException
     */
    private void insertOrUpdate(DeviceCurrentEstimateClk deviceCurrentEstimateClk) throws SQLException {
        if(null != deviceCurrentEstimateClk){
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(String.format("select device_id,content_card_click,tractate_card_click,answer_card_click,partition_date " +
                            "from device_current_estimate_clk where device_id = '%s' and partition_date = '%s'"
                    , deviceCurrentEstimateClk.getDeviceId()
                    , deviceCurrentEstimateClk.getPartitionDate())
            );
            DeviceCurrentEstimateClk newDeviceCurrentEstimateClk = null;
            if (resultSet.next()){
                newDeviceCurrentEstimateClk = new DeviceCurrentEstimateClk();
                newDeviceCurrentEstimateClk.setDeviceId(resultSet.getString("device_id"));
                newDeviceCurrentEstimateClk.setAnswerCardClick(resultSet.getLong("answer_card_click") + deviceCurrentEstimateClk.getAnswerCardClick());
                newDeviceCurrentEstimateClk.setContentCardClick(resultSet.getLong("content_card_click") + deviceCurrentEstimateClk.getContentCardClick());
                newDeviceCurrentEstimateClk.setTractateCardClick(resultSet.getLong("tractate_card_click") + deviceCurrentEstimateClk.getTractateCardClick());
                newDeviceCurrentEstimateClk.setPartitionDate(resultSet.getString("partition_date"));
            }
            if(null != newDeviceCurrentEstimateClk){
                statement.executeUpdate(String.format("update device_current_estimate_clk set content_card_click = %d,tractate_card_click = %d, answer_card_click = %d,last_update_time = '%s'" +
                                "where device_id = '%s' and partition_date = '%s'",
                        newDeviceCurrentEstimateClk.getAnswerCardClick(),
                        newDeviceCurrentEstimateClk.getContentCardClick(),
                        newDeviceCurrentEstimateClk.getTractateCardClick(),
                        newDeviceCurrentEstimateClk.getLastUpdateTime(),
                        newDeviceCurrentEstimateClk.getDeviceId(),
                        newDeviceCurrentEstimateClk.getPartitionDate()
                    )
                );
            }else{
                statement.executeUpdate(String.format("insert into device_current_estimate_clk(device_id,answer_card_click,content_card_click,tractate_card_click,partition_date,last_update_time) " +
                                "values('%s',%d,%d,%d,'%s','%s')",
                        deviceCurrentEstimateClk.getDeviceId(),
                        deviceCurrentEstimateClk.getAnswerCardClick(),
                        deviceCurrentEstimateClk.getContentCardClick(),
                        deviceCurrentEstimateClk.getTractateCardClick(),
                        deviceCurrentEstimateClk.getPartitionDate(),
                        deviceCurrentEstimateClk.getLastUpdateTime())
                );
            }
            JDBCUtils.close(null,statement,null);
        }
    }
}
