package com.gmei.data.ctr.sink;

import com.alibaba.fastjson.JSONObject;
import com.gmei.data.ctr.bean.DeviceCurrentEstimateTag;
import com.gmei.data.ctr.bean.DeviceCurrentEstimateTagTmp;
import com.gmei.data.ctr.common.Constants;
import com.gmei.data.ctr.utils.JDBCUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.sink.RichSinkFunction;

import java.sql.*;

/**
 * @ClassName CtrEstimateTagMysqlSink
 * @Description: CTR特征预估标签MysqlSink
 * @Author zhaojianwei
 * @Date 2020/3/31
 * @Version V1.0
 **/
public class CtrEstimateTagMysqlSink extends RichSinkFunction<DeviceCurrentEstimateTagTmp> {
    private int maxRetry;
    private long retryInteral;
    private String jdbcUrl;
    private Connection connection;
    public CtrEstimateTagMysqlSink(String jdbcUrl, int maxRetry, long retryInteral) {
        this.jdbcUrl = jdbcUrl;
        this.maxRetry = maxRetry;
        this.retryInteral = retryInteral;
    }
    @Override
    public void open(Configuration parameters) throws Exception {
        Class.forName(Constants.MYSQL_DRIVER_CLASS);
        connection = DriverManager.getConnection(jdbcUrl);
        super.open(parameters);
    }
    @Override
    public void invoke(DeviceCurrentEstimateTagTmp deviceCurrentEstimateTagTmp, Context context) throws Exception {
        try {
            insertOrUpdate(deviceCurrentEstimateTagTmp);
        }catch (Exception e){
            e.printStackTrace();
            int numReties = 1;
            Exception lastException = e;
            while (numReties <= maxRetry){
                try {
                    numReties++;
                    Thread.sleep(retryInteral);
                    insertOrUpdate(deviceCurrentEstimateTagTmp);
                }catch (Exception e1){
                    lastException = e1;
                    continue;
                }
                return;
            }
            throw lastException;
        }
    }
    @Override
    public void close() throws Exception {
        JDBCUtils.close(connection,null,null);
        super.close();
    }

    /**
     * 数据写入方法
     * @param deviceCurrentEstimateTagTmp
     * @throws SQLException
     */
    private void insertOrUpdate(DeviceCurrentEstimateTagTmp deviceCurrentEstimateTagTmp)  {
        DeviceCurrentEstimateTag deviceCurrentEstimateTag = null;
        DeviceCurrentEstimateTag deviceCurrentEstimateTagPlat = null;
        if(null != deviceCurrentEstimateTagTmp){
            String deviceId = deviceCurrentEstimateTagTmp.getDeviceId();
            String partitionDate = deviceCurrentEstimateTagTmp.getPartitionDate();
            String type = deviceCurrentEstimateTagTmp.getType();
            String lastUpdateTime = deviceCurrentEstimateTagTmp.getLastUpdateTime();

            String project = deviceCurrentEstimateTagTmp.getProject();
            String firstDemands = deviceCurrentEstimateTagTmp.getFirstDemands();
            String firstPositions = deviceCurrentEstimateTagTmp.getFirstPositions();
            String firstSolutions = deviceCurrentEstimateTagTmp.getFirstSolutions();
            String secondDemands = deviceCurrentEstimateTagTmp.getSecondDemands();
            String secondPositions = deviceCurrentEstimateTagTmp.getSecondPositions();
            String secondSolutions = deviceCurrentEstimateTagTmp.getSecondSolutions();
            if(StringUtils.isNotBlank(type)){
                if("commodity".equals(type) || "content".equals(type)){
                    deviceCurrentEstimateTag = new DeviceCurrentEstimateTag();
                    deviceCurrentEstimateTag.setDeviceId(deviceId);
                    deviceCurrentEstimateTag.setPartitionDate(partitionDate);
                    deviceCurrentEstimateTag.setLastUpdateTime(lastUpdateTime);
                    if("commodity".equals(type)){
                        deviceCurrentEstimateTag.setCommodityProject(project);
                        deviceCurrentEstimateTag.setCommodityFirstDemands(firstDemands);
                        deviceCurrentEstimateTag.setCommodityFirstPositions(firstPositions);
                        deviceCurrentEstimateTag.setCommodityFirstSolutions(firstSolutions);
                        deviceCurrentEstimateTag.setCommoditySecondDemands(secondDemands);
                        deviceCurrentEstimateTag.setCommoditySecondPositions(secondPositions);
                        deviceCurrentEstimateTag.setCommoditySecondSolutions(secondSolutions);
                    }else if("content".equals(type)){
                        deviceCurrentEstimateTag.setContentProject(project);
                        deviceCurrentEstimateTag.setContentFirstDemands(firstDemands);
                        deviceCurrentEstimateTag.setContentFirstPositions(firstPositions);
                        deviceCurrentEstimateTag.setContentFirstSolutions(firstSolutions);
                        deviceCurrentEstimateTag.setContentSecondDemands(secondDemands);
                        deviceCurrentEstimateTag.setContentSecondPositions(secondPositions);
                        deviceCurrentEstimateTag.setContentSecondSolutions(secondSolutions);
                    }
                }
                deviceCurrentEstimateTagPlat = new DeviceCurrentEstimateTag();
                deviceCurrentEstimateTagPlat.setDeviceId(deviceId);
                deviceCurrentEstimateTagPlat.setPartitionDate(partitionDate);
                deviceCurrentEstimateTagPlat.setLastUpdateTime(lastUpdateTime);
                deviceCurrentEstimateTagPlat.setPlatProject(project);
                deviceCurrentEstimateTagPlat.setPlatFirstDemands(firstDemands);
                deviceCurrentEstimateTagPlat.setPlatFirstPositions(firstPositions);
                deviceCurrentEstimateTagPlat.setPlatFirstSolutions(firstSolutions);
                deviceCurrentEstimateTagPlat.setPlatSecondDemands(secondDemands);
                deviceCurrentEstimateTagPlat.setPlatSecondPositions(secondPositions);
                deviceCurrentEstimateTagPlat.setPlatSecondSolutions(secondSolutions);
            }
            insertOrUpdateUnplatInfo(deviceCurrentEstimateTag);
            insertOrUpdatePlatInfo(deviceCurrentEstimateTagPlat);
        }
    }

    private void insertOrUpdatePlatInfo(DeviceCurrentEstimateTag deviceCurrentEstimateTagPlat){
        boolean isExist = false;
        try{
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(
                    String.format(
                            "select " +
                                    "device_id," +
                                    "plat_project," +
                                    "plat_first_demands," +
                                    "plat_first_positions," +
                                    "plat_first_solutions," +
                                    "plat_second_demands," +
                                    "plat_second_positions," +
                                    "plat_second_solutions," +
                                    "partition_date" +
                            "from device_current_estimate_tag_plat where device_id = '%s' and partition_date = '%s'",
                            deviceCurrentEstimateTagPlat.getDeviceId(),
                            deviceCurrentEstimateTagPlat.getPartitionDate()
                    )
            );
            JSONObject platProjectObject = new JSONObject();
            JSONObject platFirstDemandsObject = new JSONObject();
            JSONObject platFirstPositionsObject = new JSONObject();
            JSONObject platFirstSolutionsObject = new JSONObject();
            JSONObject platSecondDemandsObject = new JSONObject();
            JSONObject platSecondPositionsObject = new JSONObject();
            JSONObject platSecondSolutionsObject = new JSONObject();
            if (resultSet.next()){
                isExist = true;
                // 获取平台当天原有字符串信息
                String platProject=resultSet.getString("plat_project");
                String platFirstDemands=resultSet.getString("plat_first_demands");
                String platFirstPositions=resultSet.getString("plat_first_positions");
                String platFirstSolutions=resultSet.getString("plat_first_solutions");
                String platSecondDemands=resultSet.getString("plat_second_demands");
                String platSecondPositions=resultSet.getString("plat_second_positions");
                String platSecondSolutions=resultSet.getString("plat_second_solutions");
                // 获取平台当天原有JSON对象
                platProjectObject = StringUtils.isNotBlank(platProject) ? JSONObject.parseObject(platProject) : new JSONObject();
                platFirstDemandsObject = StringUtils.isNotBlank(platFirstDemands) ? JSONObject.parseObject(platFirstDemands) : new JSONObject();
                platFirstPositionsObject = StringUtils.isNotBlank(platFirstPositions) ? JSONObject.parseObject(platFirstPositions) : new JSONObject();
                platFirstSolutionsObject = StringUtils.isNotBlank(platFirstSolutions) ? JSONObject.parseObject(platFirstSolutions) : new JSONObject();
                platSecondDemandsObject = StringUtils.isNotBlank(platSecondDemands) ? JSONObject.parseObject(platSecondDemands) : new JSONObject();
                platSecondPositionsObject = StringUtils.isNotBlank(platSecondPositions) ? JSONObject.parseObject(platSecondPositions) : new JSONObject();
                platSecondSolutionsObject = StringUtils.isNotBlank(platSecondSolutions) ? JSONObject.parseObject(platSecondSolutions) : new JSONObject();
            }
            String platProject = deviceCurrentEstimateTagPlat.getPlatProject();
            if(StringUtils.isNotBlank(platProject)){
                if(platProjectObject.keySet().contains(platProject)){
                    Long aLong = platProjectObject.getLong(platProject);
                    platProjectObject.put(platProject,aLong + 1);
                }else{
                    platProjectObject.put(platProject,1);
                }
            }
            String platFirstDemands = deviceCurrentEstimateTagPlat.getPlatFirstDemands();
            if(StringUtils.isNotBlank(platFirstDemands)){
                if(platFirstDemandsObject.keySet().contains(platFirstDemands)){
                    Long aLong = platFirstDemandsObject.getLong(platFirstDemands);
                    platFirstDemandsObject.put(platFirstDemands,aLong + 1);
                }else{
                    platFirstDemandsObject.put(platFirstDemands,1);
                }
            }
            String platFirstPositions = deviceCurrentEstimateTagPlat.getPlatFirstPositions();
            if(StringUtils.isNotBlank(platFirstPositions)){
                if(platFirstPositionsObject.keySet().contains(platFirstPositions)){
                    Long aLong = platFirstPositionsObject.getLong(platFirstPositions);
                    platFirstPositionsObject.put(platFirstPositions,aLong + 1);
                }else{
                    platFirstPositionsObject.put(platFirstPositions,1);
                }
            }
            String platFirstSolutions = deviceCurrentEstimateTagPlat.getPlatFirstSolutions();
            if(StringUtils.isNotBlank(platFirstSolutions)){
                if(platFirstSolutionsObject.keySet().contains(platFirstSolutions)){
                    Long aLong = platFirstSolutionsObject.getLong(platFirstSolutions);
                    platFirstSolutionsObject.put(platFirstSolutions,aLong + 1);
                }else{
                    platFirstSolutionsObject.put(platFirstSolutions,1);
                }
            }
            String platSecondDemands = deviceCurrentEstimateTagPlat.getPlatSecondDemands();
            if(StringUtils.isNotBlank(platSecondDemands)){
                if(platSecondDemandsObject.keySet().contains(platSecondDemands)){
                    Long aLong = platSecondDemandsObject.getLong(platSecondDemands);
                    platSecondDemandsObject.put(platSecondDemands,aLong + 1);
                }else{
                    platSecondDemandsObject.put(platSecondDemands,1);
                }
            }
            String platSecondPositions = deviceCurrentEstimateTagPlat.getPlatSecondPositions();
            if(StringUtils.isNotBlank(platSecondPositions)){
                if(platSecondPositionsObject.keySet().contains(platSecondPositions)){
                    Long aLong = platSecondPositionsObject.getLong(platSecondPositions);
                    platSecondPositionsObject.put(platSecondPositions,aLong + 1);
                }else{
                    platSecondPositionsObject.put(platSecondPositions,1);
                }
            }
            String platSecondSolutions = deviceCurrentEstimateTagPlat.getPlatSecondSolutions();
            if(StringUtils.isNotBlank(platSecondSolutions)){
                if(platSecondSolutionsObject.keySet().contains(platSecondSolutions)){
                    Long aLong = platSecondSolutionsObject.getLong(platSecondSolutions);
                    platSecondSolutionsObject.put(platSecondSolutions,aLong + 1);
                }else{
                    platSecondSolutionsObject.put(platSecondSolutions,1);
                }
            }
            if(isExist){
                statement.executeUpdate(
                    String.format(
                        "update device_current_estimate_tag_plat set " +
                                "plat_project = '%s'," +
                                "plat_first_demands = '%s'," +
                                "plat_first_positions = '%s'," +
                                "plat_first_solutions = '%s'," +
                                "plat_second_demands = '%s'," +
                                "plat_second_positions = '%s'," +
                                "plat_second_solutions = '%s'," +
                                "last_update_time = '%s'"
                            + "where device_id = '%s' and partition_date = '%s'",
                            deviceCurrentEstimateTagPlat.getPlatProject(),
                            deviceCurrentEstimateTagPlat.getPlatFirstDemands(),
                            deviceCurrentEstimateTagPlat.getPlatFirstPositions(),
                            deviceCurrentEstimateTagPlat.getPlatFirstSolutions(),
                            deviceCurrentEstimateTagPlat.getPlatSecondDemands(),
                            deviceCurrentEstimateTagPlat.getPlatSecondPositions(),
                            deviceCurrentEstimateTagPlat.getPlatFirstSolutions(),
                            deviceCurrentEstimateTagPlat.getLastUpdateTime(),
                            deviceCurrentEstimateTagPlat.getDeviceId(),
                            deviceCurrentEstimateTagPlat.getPartitionDate()
                    )
                );
            }else{
                statement.executeUpdate(
                    String.format(
                        "insert into device_current_estimate_tag_plat("+
                                "device_id," +
                                "plat_project," +
                                "plat_first_demands," +
                                "plat_first_positions," +
                                "plat_first_solutions," +
                                "plat_second_demands," +
                                "plat_second_positions," +
                                "plat_second_solutions," +
                                "partition_date," +
                                "last_update_time"
                            + ") values ('%s','%s','%s','%s','%s','%s','%s','%s','%s','%s')",
                        deviceCurrentEstimateTagPlat.getDeviceId(),
                        deviceCurrentEstimateTagPlat.getPlatProject(),
                        deviceCurrentEstimateTagPlat.getPlatFirstDemands(),
                        deviceCurrentEstimateTagPlat.getPlatFirstPositions(),
                        deviceCurrentEstimateTagPlat.getPlatFirstSolutions(),
                        deviceCurrentEstimateTagPlat.getPlatSecondDemands(),
                        deviceCurrentEstimateTagPlat.getPlatSecondPositions(),
                        deviceCurrentEstimateTagPlat.getPlatSecondSolutions(),
                        deviceCurrentEstimateTagPlat.getPartitionDate(),
                        deviceCurrentEstimateTagPlat.getLastUpdateTime()
                    )
                );
            }
            JDBCUtils.close(null,statement,null);
        }catch (Exception e){
            e.printStackTrace();
        }
    }

    private void insertOrUpdateUnplatInfo(DeviceCurrentEstimateTag deviceCurrentEstimateTag){
        boolean isExist = false;
        try{
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(
                    String.format(
                            "select " +
                                "device_id," +
                                "commodity_project," +
                                "commodity_first_demands," +
                                "commodity_first_positions," +
                                "commodity_first_solutions," +
                                "commodity_second_positions," +
                                "commodity_second_solutions," +
                                "commodity_second_demands," +
                                "content_project," +
                                "content_first_demands," +
                                "content_first_positions," +
                                "content_first_solutions," +
                                "content_second_demands," +
                                "content_second_positions," +
                                "content_second_solutions," +
                                "partition_date" +
                            "from device_current_estimate_tag_unplat where device_id = '%s' and partition_date = '%s'",
                            deviceCurrentEstimateTag.getDeviceId(),deviceCurrentEstimateTag.getPartitionDate()));
            JSONObject commodityProjectObject = new JSONObject();
            JSONObject commodityFirstDemandsObject = new JSONObject();
            JSONObject commodityFirstPositionsObject = new JSONObject();
            JSONObject commodityFirstSolutionsObject = new JSONObject();
            JSONObject commoditySecondDemandsObject = new JSONObject();
            JSONObject commoditySecondPositionsObject = new JSONObject();
            JSONObject commoditySecondSolutionsObject = new JSONObject();
            JSONObject contentProjectObject = new JSONObject();
            JSONObject contentFirstDemandsObject = new JSONObject();
            JSONObject contentFirstPositionsObject = new JSONObject();
            JSONObject contentFirstSolutionsObject = new JSONObject();
            JSONObject contentSecondDemandsObject = new JSONObject();
            JSONObject contentSecondPositionsObject = new JSONObject();
            JSONObject contentSecondSolutionsObject = new JSONObject();
            if (resultSet.next()){
                isExist = true;
                // 获取商品当天原有字符串信息
                String commodityProject=resultSet.getString("commodity_project");
                String commodityFirstDemands=resultSet.getString("commodity_first_demands");
                String commodityFirstPositions=resultSet.getString("commodity_first_positions");
                String commodityFirstSolutions=resultSet.getString("commodity_first_solutions");
                String commoditySecondDemands=resultSet.getString("commodity_second_demands");
                String commoditySecondPositions=resultSet.getString("commodity_second_positions");
                String commoditySecondSolutions=resultSet.getString("commodity_second_solutions");
                // 获取内容当天原有字符串信息
                String contentProject=resultSet.getString("content_project");
                String contentFirstDemands=resultSet.getString("content_first_demands");
                String contentFirstPositions=resultSet.getString("content_first_positions");
                String contentFirstSolutions=resultSet.getString("content_first_solutions");
                String contentSecondDemands=resultSet.getString("content_second_demands");
                String contentSecondPositions=resultSet.getString("content_second_positions");
                String contentSecondSolutions=resultSet.getString("content_second_solutions");
                // 获取商品当天原有JSON对象
                commodityProjectObject = StringUtils.isNotBlank(commodityProject) ? JSONObject.parseObject(commodityProject) : new JSONObject();
                commodityFirstDemandsObject = StringUtils.isNotBlank(commodityFirstDemands) ? JSONObject.parseObject(commodityFirstDemands) : new JSONObject();
                commodityFirstPositionsObject = StringUtils.isNotBlank(commodityFirstPositions) ? JSONObject.parseObject(commodityFirstPositions) : new JSONObject();
                commodityFirstSolutionsObject = StringUtils.isNotBlank(commodityFirstSolutions) ? JSONObject.parseObject(commodityFirstSolutions) : new JSONObject();
                commoditySecondDemandsObject = StringUtils.isNotBlank(commoditySecondDemands) ? JSONObject.parseObject(commoditySecondDemands) : new JSONObject();
                commoditySecondPositionsObject = StringUtils.isNotBlank(commoditySecondPositions) ? JSONObject.parseObject(commoditySecondPositions) : new JSONObject();
                commoditySecondSolutionsObject = StringUtils.isNotBlank(commoditySecondSolutions) ? JSONObject.parseObject(commoditySecondSolutions) : new JSONObject();
                // 获取内容当天原有JSON对象
                contentProjectObject = StringUtils.isNotBlank(contentProject) ? JSONObject.parseObject(contentProject) : new JSONObject();
                contentFirstDemandsObject = StringUtils.isNotBlank(contentFirstDemands) ? JSONObject.parseObject(contentFirstDemands) : new JSONObject();
                contentFirstPositionsObject = StringUtils.isNotBlank(contentFirstPositions) ? JSONObject.parseObject(contentFirstPositions) : new JSONObject();
                contentFirstSolutionsObject = StringUtils.isNotBlank(contentFirstSolutions) ? JSONObject.parseObject(contentFirstSolutions) : new JSONObject();
                contentSecondDemandsObject = StringUtils.isNotBlank(contentSecondDemands) ? JSONObject.parseObject(contentSecondDemands) : new JSONObject();
                contentSecondPositionsObject = StringUtils.isNotBlank(contentSecondPositions) ? JSONObject.parseObject(contentSecondPositions) : new JSONObject();
                contentSecondSolutionsObject = StringUtils.isNotBlank(contentSecondSolutions) ? JSONObject.parseObject(contentSecondSolutions) : new JSONObject();
            }
            String commodityProject = deviceCurrentEstimateTag.getCommodityProject();
            if(StringUtils.isNotBlank(commodityProject)){
                if(commodityProjectObject.keySet().contains(commodityProject)){
                    Long aLong = commodityProjectObject.getLong(commodityProject);
                    commodityProjectObject.put(commodityProject,aLong + 1);
                }else{
                    commodityProjectObject.put(commodityProject,1);
                }
            }
            String commodityFirstDemands = deviceCurrentEstimateTag.getCommodityFirstDemands();
            if(StringUtils.isNotBlank(commodityFirstDemands)){
                if(commodityFirstDemandsObject.keySet().contains(commodityFirstDemands)){
                    Long aLong = commodityFirstDemandsObject.getLong(commodityFirstDemands);
                    commodityFirstDemandsObject.put(commodityFirstDemands,aLong + 1);
                }else{
                    commodityFirstDemandsObject.put(commodityFirstDemands,1);
                }
            }
            String commodityFirstPositions = deviceCurrentEstimateTag.getCommodityFirstPositions();
            if(StringUtils.isNotBlank(commodityFirstPositions)){
                if(commodityFirstPositionsObject.keySet().contains(commodityFirstPositions)){
                    Long aLong = commodityFirstPositionsObject.getLong(commodityFirstPositions);
                    commodityFirstPositionsObject.put(commodityFirstPositions,aLong + 1);
                }else{
                    commodityFirstPositionsObject.put(commodityFirstPositions,1);
                }
            }
            String commodityFirstSolutions = deviceCurrentEstimateTag.getCommodityFirstSolutions();
            if(StringUtils.isNotBlank(commodityFirstSolutions)){
                if(commodityFirstSolutionsObject.keySet().contains(commodityFirstSolutions)){
                    Long aLong = commodityFirstSolutionsObject.getLong(commodityFirstSolutions);
                    commodityFirstSolutionsObject.put(commodityFirstSolutions,aLong + 1);
                }else{
                    commodityFirstSolutionsObject.put(commodityFirstSolutions,1);
                }
            }
            String commoditySecondDemands = deviceCurrentEstimateTag.getCommoditySecondDemands();
            if(StringUtils.isNotBlank(commoditySecondDemands)){
                if(commoditySecondDemandsObject.keySet().contains(commoditySecondDemands)){
                    Long aLong = commoditySecondDemandsObject.getLong(commoditySecondDemands);
                    commoditySecondDemandsObject.put(commoditySecondDemands,aLong + 1);
                }else{
                    commodityFirstSolutionsObject.put(commoditySecondDemands,1);
                }
            }
            String commoditySecondPositions = deviceCurrentEstimateTag.getCommoditySecondPositions();
            if(StringUtils.isNotBlank(commoditySecondPositions)){
                if(commoditySecondPositionsObject.keySet().contains(commoditySecondPositions)){
                    Long aLong = commoditySecondPositionsObject.getLong(commoditySecondPositions);
                    commoditySecondPositionsObject.put(commoditySecondPositions,aLong + 1);
                }else{
                    commoditySecondPositionsObject.put(commoditySecondPositions,1);
                }
            }
            String commoditySecondSolutions = deviceCurrentEstimateTag.getCommoditySecondSolutions();
            if(StringUtils.isNotBlank(commoditySecondSolutions)){
                if(commoditySecondSolutionsObject.keySet().contains(commoditySecondSolutions)){
                    Long aLong = commoditySecondSolutionsObject.getLong(commoditySecondSolutions);
                    commoditySecondSolutionsObject.put(commoditySecondSolutions,aLong + 1);
                }else{
                    commoditySecondSolutionsObject.put(commoditySecondSolutions,1);
                }
            }
            String contentProject = deviceCurrentEstimateTag.getContentProject();
            if(StringUtils.isNotBlank(contentProject)){
                if(contentProjectObject.keySet().contains(contentProject)){
                    Long aLong = contentProjectObject.getLong(contentProject);
                    contentProjectObject.put(contentProject,aLong + 1);
                }else{
                    contentProjectObject.put(contentProject,1);
                }
            }
            String contentFirstDemands = deviceCurrentEstimateTag.getContentFirstDemands();
            if(StringUtils.isNotBlank(contentFirstDemands)){
                if(contentFirstDemandsObject.keySet().contains(contentFirstDemands)){
                    Long aLong = contentFirstDemandsObject.getLong(contentFirstDemands);
                    contentFirstDemandsObject.put(contentFirstDemands,aLong + 1);
                }else{
                    contentFirstDemandsObject.put(contentFirstDemands,1);
                }
            }
            String contentFirstPositions = deviceCurrentEstimateTag.getContentFirstPositions();
            if(StringUtils.isNotBlank(contentFirstPositions)){
                if(contentFirstPositionsObject.keySet().contains(contentFirstPositions)){
                    Long aLong = contentFirstPositionsObject.getLong(contentFirstPositions);
                    contentFirstPositionsObject.put(contentFirstPositions,aLong + 1);
                }else{
                    contentFirstPositionsObject.put(contentFirstPositions,1);
                }
            }
            String contentFirstSolutions = deviceCurrentEstimateTag.getContentFirstSolutions();
            if(StringUtils.isNotBlank(contentFirstSolutions)){
                if(contentFirstSolutionsObject.keySet().contains(contentFirstSolutions)){
                    Long aLong = contentFirstSolutionsObject.getLong(contentFirstSolutions);
                    contentFirstSolutionsObject.put(contentFirstSolutions,aLong + 1);
                }else{
                    contentFirstSolutionsObject.put(contentFirstSolutions,1);
                }
            }
            String contentSecondDemands = deviceCurrentEstimateTag.getContentSecondDemands();
            if(StringUtils.isNotBlank(contentSecondDemands)){
                if(contentSecondDemandsObject.keySet().contains(contentSecondDemands)){
                    Long aLong = contentSecondDemandsObject.getLong(contentSecondDemands);
                    contentSecondDemandsObject.put(contentSecondDemands,aLong + 1);
                }else{
                    contentSecondDemandsObject.put(contentSecondDemands,1);
                }
            }
            String contentSecondPositions = deviceCurrentEstimateTag.getContentSecondPositions();
            if(StringUtils.isNotBlank(contentSecondPositions)){
                if(contentSecondPositionsObject.keySet().contains(contentSecondPositions)){
                    Long aLong = contentSecondPositionsObject.getLong(contentSecondPositions);
                    contentSecondPositionsObject.put(contentSecondPositions,aLong + 1);
                }else{
                    contentSecondPositionsObject.put(contentSecondPositions,1);
                }
            }
            String contentSecondSolutions = deviceCurrentEstimateTag.getContentSecondSolutions();
            if(StringUtils.isNotBlank(contentSecondSolutions)){
                if(contentSecondSolutionsObject.keySet().contains(contentSecondSolutions)){
                    Long aLong = contentSecondSolutionsObject.getLong(contentSecondSolutions);
                    contentSecondSolutionsObject.put(contentSecondSolutions,aLong + 1);
                }else{
                    contentSecondSolutionsObject.put(contentSecondSolutions,1);
                }
            }
            if(isExist){
                statement.executeUpdate(
                        String.format(
                                "update device_current_estimate_tag_unplat set " +
                                        "commodity_project = '%s'," +
                                        "commodity_first_demands = '%s'," +
                                        "commodity_first_positions = '%s'," +
                                        "commodity_first_solutions = '%s'," +
                                        "commodity_second_demands = '%s'," +
                                        "commodity_second_positions = '%s'," +
                                        "commodity_second_solutions = '%s'," +
                                        "content_project = '%s'," +
                                        "content_first_demands = '%s'," +
                                        "content_first_positions = '%s'," +
                                        "content_first_solutions = '%s'," +
                                        "content_second_demands = '%s'," +
                                        "content_second_positions = '%s'," +
                                        "content_second_solutions = '%s'," +
                                        "last_update_time = '%s'" +
                                        "where device_id = '%s' and partition_date = '%s'",
                                deviceCurrentEstimateTag.getCommodityProject(),
                                deviceCurrentEstimateTag.getCommodityFirstDemands(),
                                deviceCurrentEstimateTag.getCommodityFirstPositions(),
                                deviceCurrentEstimateTag.getCommodityFirstSolutions(),
                                deviceCurrentEstimateTag.getCommoditySecondDemands(),
                                deviceCurrentEstimateTag.getCommoditySecondPositions(),
                                deviceCurrentEstimateTag.getCommoditySecondSolutions(),
                                deviceCurrentEstimateTag.getContentProject(),
                                deviceCurrentEstimateTag.getContentFirstDemands(),
                                deviceCurrentEstimateTag.getContentFirstPositions(),
                                deviceCurrentEstimateTag.getContentFirstSolutions(),
                                deviceCurrentEstimateTag.getContentSecondDemands(),
                                deviceCurrentEstimateTag.getContentSecondPositions(),
                                deviceCurrentEstimateTag.getContentSecondSolutions(),
                                deviceCurrentEstimateTag.getLastUpdateTime(),
                                deviceCurrentEstimateTag.getDeviceId(),
                                deviceCurrentEstimateTag.getPartitionDate()
                        )
                );
            }else{
                statement.executeUpdate(
                        String.format(
                                "insert into device_current_estimate_tag_unplat(" +
                                        "device_id," +
                                        "commodity_project," +
                                        "commodity_first_demands," +
                                        "commodity_first_positions," +
                                        "commodity_first_solutions," +
                                        "commodity_second_positions," +
                                        "commodity_second_solutions," +
                                        "commodity_second_demands," +
                                        "content_project," +
                                        "content_first_demands," +
                                        "content_first_positions," +
                                        "content_first_solutions," +
                                        "content_second_demands," +
                                        "content_second_positions," +
                                        "content_second_solutions," +
                                        "partition_date," +
                                        "last_update_time" +
                                        ") values ('%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s')",
                                deviceCurrentEstimateTag.getDeviceId(),
                                deviceCurrentEstimateTag.getCommodityProject(),
                                deviceCurrentEstimateTag.getCommodityFirstDemands(),
                                deviceCurrentEstimateTag.getCommodityFirstPositions(),
                                deviceCurrentEstimateTag.getCommodityFirstSolutions(),
                                deviceCurrentEstimateTag.getCommoditySecondDemands(),
                                deviceCurrentEstimateTag.getCommoditySecondPositions(),
                                deviceCurrentEstimateTag.getCommoditySecondSolutions(),
                                deviceCurrentEstimateTag.getContentProject(),
                                deviceCurrentEstimateTag.getContentFirstDemands(),
                                deviceCurrentEstimateTag.getContentFirstPositions(),
                                deviceCurrentEstimateTag.getContentFirstSolutions(),
                                deviceCurrentEstimateTag.getContentSecondDemands(),
                                deviceCurrentEstimateTag.getContentSecondPositions(),
                                deviceCurrentEstimateTag.getContentSecondSolutions(),
                                deviceCurrentEstimateTag.getPartitionDate(),
                                deviceCurrentEstimateTag.getLastUpdateTime()
                        )
                );
                JDBCUtils.close(null,statement,null);
            }
        }catch (Exception e){
            e.printStackTrace();
        }
    }
}
