package com.gmei.data.ctr;

import com.gmei.data.ctr.operator.CtrEstimateClkOperator;
import com.gmei.data.ctr.operator.CtrEstimateTagOperator;
import com.gmei.data.ctr.source.MaidianKafkaSource;
import org.apache.flink.api.common.restartstrategy.RestartStrategies;
import org.apache.flink.api.java.utils.ParameterTool;
import org.apache.flink.runtime.state.filesystem.FsStateBackend;
import org.apache.flink.streaming.api.TimeCharacteristic;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.environment.CheckpointConfig;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;

/**
 * @ClassName CtrEstimateMain
 * @Description: CTR预估特征实时处理入口
 * @Author apple
 * @Date 2020/3/30
 * @Version V1.0
 **/
public class CtrEstimateMain {

    public static void main(String[] args) throws Exception{
        // 获取运行参数
        ParameterTool parameterTool = ParameterTool.fromArgs(args);
        String inBrokers = parameterTool.get("inBrokers","test003:9092");
        String batchSize = parameterTool.get("batchSize","1000");
        String maidianInTopic = parameterTool.get("maidianInTopic", "test11");
        String maidianInGroupId = parameterTool.get("maidianInGroupId","ctr-estimate");
        Integer windowSize = parameterTool.getInt("windowSize",60);
        Integer slideSize = parameterTool.getInt("slideSize",60);
        String jdbcUrl = parameterTool.get("outJdbcUrl",
                "jdbc:mysql://test002:3306/jerry_test?user=root&password=5OqYM^zLwotJ3oSo&autoReconnect=true&useSSL=false");
        Integer maxRetry = parameterTool.getInt("maxRetry",3);
        Long retryInteral = parameterTool.getLong("retryInteral",3000);
        String checkpointPath = parameterTool.get("checkpointPath","hdfs://bj-gmei-hdfs/user/data/flink/ctr-estimate/checkpoint");
        Boolean isStartFromEarliest = parameterTool.getBoolean("isStartFromEarliest",false);
        Boolean isStartFromLatest = parameterTool.getBoolean("isStartFromLatest",false);
        String startTime = parameterTool.get("startTime");
        Integer parallelism = parameterTool.getInt("parallelism",2);

        // 获得流处理环境对象
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        //env.setStreamTimeCharacteristic(TimeCharacteristic.EventTime);
        //        env.enableCheckpointing(1000);
        //        env.setStateBackend(new FsStateBackend(checkpointPath));
        //        env.setRestartStrategy(RestartStrategies.fixedDelayRestart(1, 3000));
        //        CheckpointConfig config = env.getCheckpointConfig();
        //        config.enableExternalizedCheckpoints(CheckpointConfig.ExternalizedCheckpointCleanup.RETAIN_ON_CANCELLATION);

        DataStream MaidianDataStream = new MaidianKafkaSource(
                env,
                inBrokers,
                maidianInTopic,
                maidianInGroupId,
                batchSize,
                isStartFromEarliest,
                isStartFromLatest,
                startTime
        ).getInstance();

        // 执行处理核心逻辑
        new CtrEstimateClkOperator(MaidianDataStream,jdbcUrl,maxRetry,retryInteral,parallelism).run();
        //new CtrEstimateTagOperator(MaidianDataStream,jdbcUrl,maxRetry,retryInteral,parallelism).run();

        // 常驻执行
        env.execute("ctr-estimate");
    }
}
