package com.gmei.data.ctr.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;

/**
 * ClassName: SimpleCacheService
 * Reason: 缓存实现类
 * Date: 2020-03-31 13:00:00
 *
 * @author zhaojianwei
 * @since JDK 1.8
 */
public class SimpleCacheService<K, V> extends CacheService<K, V> {
    private int maximumSize = 1000;
    private int expireAfterWrite = 1;
    private Cache<K, V> cache = null;

    public SimpleCacheService() {
        createCache();
    }
    public SimpleCacheService(int maximumSize, int expireAfterWrite) {
        this.maximumSize = maximumSize;
        this.expireAfterWrite = expireAfterWrite;
        createCache();
    }

    @Override
    public void invalidate(Object key) {
        cache.invalidate(key);
    }

    @Override
    public void putValue(K key, V value) {
        cache.put(key, value);
    }

    @Override
    public Long cacheSize() {
        return this.cache.size();
    }

    @Override
    public V getValue(final K key, final Callable<V> callable) {
        try {
            return cache.get(key, callable);
        } catch (ExecutionException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void clearCache(){
        this.cache.invalidateAll();
    }

    public void createCache() {
        cache = CacheBuilder
                .newBuilder()
                .maximumSize(maximumSize)
                .expireAfterWrite(expireAfterWrite, TimeUnit.SECONDS)
                .build();
    }
}
