package com.gmei.data.ctr.source;

import com.alibaba.druid.pool.DruidDataSource;
import com.gmei.data.ctr.bean.CtrTagCrtEtlBean;
import com.gmei.data.ctr.bean.CtrTagCrtTmpBean;
import com.gmei.data.ctr.common.Constants;
import com.gmei.data.ctr.utils.DateUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.async.ResultFuture;
import org.apache.flink.streaming.api.functions.async.RichAsyncFunction;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Collections;
import java.util.Date;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.Supplier;

import static java.util.concurrent.Executors.newFixedThreadPool;

/**
 * @ClassName MysqlAsyncSource
 * @Author apple
 * @Date 2020/3/29
 * @Version V1.0
 **/
public class JrAsyncTagCrtSource extends RichAsyncFunction<CtrTagCrtEtlBean, CtrTagCrtTmpBean> {
    private String jerryJdbcUrl;
    private String jerryUsername;
    private String jerryPassword;
    private transient DruidDataSource dataSource;
    private transient ExecutorService executorService;

    public JrAsyncTagCrtSource(String jerryJdbcUrl, String jerryUsername, String jerryPassword) {
        this.jerryJdbcUrl = jerryJdbcUrl;
        this.jerryUsername = jerryUsername;
        this.jerryPassword = jerryPassword;
    }

    @Override
    public void open(Configuration parameters) throws Exception {
        super.open(parameters);
        executorService = newFixedThreadPool(20);
        dataSource = new DruidDataSource();
        dataSource.setDriverClassName(Constants.MYSQL_DRIVER_CLASS);
        dataSource.setUrl(jerryJdbcUrl);
        dataSource.setUsername(jerryUsername);
        dataSource.setPassword(jerryPassword);

        dataSource.setInitialSize(5);
        dataSource.setMinIdle(10);
        dataSource.setMaxActive(20);
    }

    @Override
    public void asyncInvoke(CtrTagCrtEtlBean ctrTagCrtEtlBean, ResultFuture<CtrTagCrtTmpBean> resultFuture) throws Exception {
        Future<CtrTagCrtTmpBean> future = executorService.submit(() -> {
            return queryFromMySql(ctrTagCrtEtlBean);
        });
        CompletableFuture.supplyAsync(new Supplier<CtrTagCrtTmpBean>() {
            @Override
            public CtrTagCrtTmpBean get() {
                try {
                    return future.get();
                } catch (Exception e) {
                    return null;
                }
            }
        }).thenAccept((CtrTagCrtTmpBean dbResult) ->{
            resultFuture.complete(Collections.singleton(dbResult));
        });
    }

    private CtrTagCrtTmpBean queryFromMySql(CtrTagCrtEtlBean ctrTagCrtEtlBean)  {
        CtrTagCrtTmpBean dcett = null;
        String type = ctrTagCrtEtlBean.getType();
        if("commodity".equals(type) || "content".equals(type)){
            String sql = null;
            String cardContentType = ctrTagCrtEtlBean.getCardContentType();
            Long cardId = ctrTagCrtEtlBean.getCardId();
            if("commodity".equals(type) && "service".equals(cardContentType)){
                sql = String.format("select first_demands,first_positions,first_solutions,second_demands,second_positions,second_solutions,project_tags " +
                        "from strategy_service_tagv3_info where service_id = '%d'",cardId);
            }
            if("content".equals(type)){
                if("diary".equals(cardContentType)){
                    sql = String.format("select first_demands,first_positions,first_solutions,second_demands,second_positions,second_solutions,project_tags " +
                            "from strategy_content_tagv3_info where content_id = '%d'",cardId);
                }else if("tractate".equals(cardContentType)){
                    sql = String.format("select first_demands,first_positions,first_solutions,second_demands,second_positions,second_solutions,project_tags " +
                            "from strategy_tractate_tagv3_info where content_id = '%d'",cardId);
                }else if("answer".equals(cardContentType)){
                    sql = String.format("select first_demands,first_positions,first_solutions,second_demands,second_positions,second_solutions,project_tags " +
                            "from strategy_answer_tagv3_info where content_id = '%d'",cardId);
                }
            }
            if(StringUtils.isNotBlank(sql)){
                dcett = findTagInfo(sql);
                if(null != dcett){
                    Date date = new Date();
                    dcett.setType(type);
                    dcett.setDeviceId(ctrTagCrtEtlBean.getDeviceId());
                    dcett.setPartitionDate(DateUtils.getDateStr(date));
                    dcett.setLastUpdateTime(DateUtils.getTimeStr(date));
                }
            }
        }
        return dcett;
    }

    private CtrTagCrtTmpBean findTagInfo(String sql){
        CtrTagCrtTmpBean ctrTagCrtTmpBean = null;
        Connection connection = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            connection = dataSource.getConnection();
            stmt = connection.prepareStatement(sql);
            rs = stmt.executeQuery();
            while(rs.next()){
                ctrTagCrtTmpBean = new CtrTagCrtTmpBean();
                ctrTagCrtTmpBean.setProject(rs.getString("project_tags"));
                ctrTagCrtTmpBean.setFirstDemands(rs.getString("first_demands"));
                ctrTagCrtTmpBean.setFirstPositions(rs.getString("first_positions"));
                ctrTagCrtTmpBean.setFirstSolutions(rs.getString("first_solutions"));
                ctrTagCrtTmpBean.setSecondDemands(rs.getString("second_demands"));
                ctrTagCrtTmpBean.setSecondPositions(rs.getString("second_positions"));
                ctrTagCrtTmpBean.setSecondSolutions(rs.getString("second_solutions"));
            }
        } catch (Exception e){
            e.printStackTrace();
        }finally {
            try{
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }catch (Exception e){
                e.printStackTrace();
            }
        }
        return ctrTagCrtTmpBean;
    }

    @Override
    public void close() {
        dataSource.close();
        executorService.shutdown();
    }
}