--CREATE SCHEMA `jerry_test` DEFAULT CHARACTER SET utf8mb4 ;

-- CTR特征预估点击量表
CREATE TABLE `device_current_estimate_clk` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `device_id` varchar(150) DEFAULT NULL COMMENT '设备ID',
  `content_card_click` bigint(20) DEFAULT NULL COMMENT '日记贴点击量',
  `tractate_card_click` bigint(20) DEFAULT NULL COMMENT '用户贴点击量',
  `answer_card_click` bigint(20) DEFAULT NULL COMMENT '问答贴点击量',
  `partition_date` varchar(45) DEFAULT NULL COMMENT '日期',
  `last_update_time` varchar(45) DEFAULT NULL COMMENT '上一次更改的时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- CTR特征预估标签平台表
CREATE TABLE `device_current_estimate_tag_plat` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `device_id` varchar(150) DEFAULT NULL COMMENT '设备ID',
  `plat_first_positions` text COMMENT '当日平台一级部位偏好',
  `plat_first_solutions` text COMMENT '当日平台一级方式偏好',
  `plat_first_demands` text COMMENT '当日平台项目偏好',
  `plat_project` text COMMENT '当日平台一级诉求偏好',
  `plat_second_positions` text COMMENT '当日平台二级部位偏好',
  `plat_second_solutions` text COMMENT '当日平台二级方式偏好',
  `plat_second_demands` text COMMENT '当日平台二级诉求偏好',
  `partition_date` varchar(45) DEFAULT NULL COMMENT '日期',
  `last_update_time` varchar(45) DEFAULT NULL COMMENT '上一次更改的时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- CTR特征预估标签非平台表
CREATE TABLE `device_current_estimate_tag_unplat` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `device_id` varchar(150) DEFAULT NULL COMMENT '设备ID',
  `commodity_project` text COMMENT '当日内容项目偏好',
  `commodity_first_demands` text COMMENT '当日内容一级诉求偏好',
  `commodity_first_positions` text COMMENT '当日商品一级部位偏好',
  `commodity_first_solutions` text COMMENT '当日商品一级方式偏好',
  `commodity_second_demands` text COMMENT '当日商品二级诉求偏好',
  `commodity_second_positions` text COMMENT '当日商品二级部位偏好',
  `commodity_second_solutions` text COMMENT '当日商品二级方式偏好',
  `content_project` text COMMENT '当日内容项目偏好',
  `content_first_demands` text COMMENT '当日内容一级诉求偏好',
  `content_first_positions` text COMMENT '当日内容一级部位偏好',
  `content_first_solutions` text COMMENT '当日内容一级方式偏好',
  `content_second_demands` text COMMENT '当日内容二级诉求偏好',
  `content_second_positions` text COMMENT '当日内容二级部位偏好',
  `content_second_solutions` text COMMENT '当日内容二级方式偏好',
  `partition_date` varchar(45) DEFAULT NULL COMMENT '日期',
  `last_update_time` varchar(45) DEFAULT NULL COMMENT '上一次更改的时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- CTR特征预估标签表
CREATE TABLE `device_current_estimate` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `device_id` varchar(150) DEFAULT NULL COMMENT '设备ID',
  `content_card_click` bigint(20) DEFAULT NULL COMMENT '日记贴点击量',
  `tractate_card_click` bigint(20) DEFAULT NULL COMMENT '用户贴点击量',
  `answer_card_click` bigint(20) DEFAULT NULL COMMENT '问答贴点击量',
  `plat_first_positions` text COMMENT '当日平台一级部位偏好',
  `plat_first_solutions` text COMMENT '当日平台一级方式偏好',
  `plat_first_demands` text COMMENT '当日平台项目偏好',
  `plat_project` text COMMENT '当日平台一级诉求偏好',
  `content_first_positions` text COMMENT '当日内容一级部位偏好',
  `content_first_solutions` text COMMENT '当日内容一级方式偏好',
  `content_first_demands` text COMMENT '当日内容一级诉求偏好',
  `content_project` text COMMENT '当日内容项目偏好',
  `commodity_first_positions` text COMMENT '当日商品一级部位偏好',
  `commodity_first_solutions` text COMMENT '当日商品一级方式偏好',
  `commodity_first_demands` text COMMENT '当日内容一级诉求偏好',
  `commodity_project` text COMMENT '当日内容项目偏好',
  `plat_second_positions` text COMMENT '当日平台二级部位偏好',
  `plat_second_solutions` text COMMENT '当日平台二级方式偏好',
  `plat_second_demands` text COMMENT '当日平台二级诉求偏好',
  `content_second_positions` text COMMENT '当日内容二级部位偏好',
  `content_second_solutions` text COMMENT '当日内容二级方式偏好',
  `content_second_demands` text COMMENT '当日内容二级诉求偏好',
  `commodity_second_positions` text COMMENT '当日商品二级部位偏好',
  `commodity_second_solutions` text COMMENT '当日商品二级方式偏好',
  `commodity_second_demands` text COMMENT '当日商品二级诉求偏好',
  `partition_date` varchar(45) DEFAULT NULL COMMENT '日期',
  `last_update_time` varchar(45) DEFAULT NULL COMMENT '上一次更改的时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;