CREATE SCHEMA `flink_monitor` DEFAULT CHARACTER SET utf8mb4 ;

USE flink_monitor;

CREATE TABLE `tbl_monitor_portrait_err` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `log_content` text DEFAULT NULL COMMENT '日志内容',
  `monitor_time` varchar(45) DEFAULT NULL COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `tbl_monitor_portrait_shd` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `action_shd` varchar(100) DEFAULT NULL COMMENT '操作类型',
  `count_shd` int(11) DEFAULT NULL COMMENT '计划打点数',
  `monitor_time` varchar(45) DEFAULT NULL COMMENT '监控时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `tbl_monitor_portrait_suc` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `action_suc` varchar(100) DEFAULT NULL COMMENT '操作类型',
  `count_suc` int(11) DEFAULT NULL COMMENT '实际打点数',
  `monitor_time` varchar(45) DEFAULT NULL COMMENT '监控时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `tbl_mapping_action_name` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `action` varchar(100) DEFAULT NULL COMMENT '操作类型',
  `name` varchar(50) DEFAULT NULL COMMENT '操作名称',
  `comment` varchar(300) DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

INSERT INTO `flink_monitor`.`tbl_mapping_action_name` (`id`, `action`, `name`) VALUES ('1', 'do_search', '客户端-搜索');
INSERT INTO `flink_monitor`.`tbl_mapping_action_name` (`id`, `action`, `name`) VALUES ('2', 'goto_welfare_detail', '客户端-点击美购卡片');
INSERT INTO `flink_monitor`.`tbl_mapping_action_name` (`id`, `action`, `name`) VALUES ('3', 'on_click_card', '客户端-点击内容卡片');
INSERT INTO `flink_monitor`.`tbl_mapping_action_name` (`id`, `action`, `name`) VALUES ('4', 'home_click_section', '客户端-点击首页icon');
INSERT INTO `flink_monitor`.`tbl_mapping_action_name` (`id`, `action`, `name`) VALUES ('5', '/api/private_conversation/', '后端-主动咨询');
INSERT INTO `flink_monitor`.`tbl_mapping_action_name` (`id`, `action`, `name`) VALUES ('6', '/api/initiate/interest_record', '后端-kyc720');
INSERT INTO `flink_monitor`.`tbl_mapping_action_name` (`id`, `action`, `name`) VALUES ('7', '/api/one_image/share/v3', '后端-ai侧脸');
INSERT INTO `flink_monitor`.`tbl_mapping_action_name` (`id`, `action`, `name`) VALUES ('8', '/gm_ai/face_app/test_skin', '后端-ai测肤');
INSERT INTO `flink_monitor`.`tbl_mapping_action_name` (`id`, `action`, `name`) VALUES ('9', 'validate_order', '后端-验证订单');
INSERT INTO `flink_monitor`.`tbl_mapping_action_name` (`id`, `action`, `name`) VALUES ('10', 'paid_success', '后端-支付订单');
INSERT INTO `flink_monitor`.`tbl_mapping_action_name` (`id`, `action`, `name`) VALUES ('11', 'add_shopcart', '后端-加车操作');
INSERT INTO `flink_monitor`.`tbl_mapping_action_name` (`id`, `action`, `name`) VALUES ('12', 'create', '后端-撰写操作-create');
INSERT INTO `flink_monitor`.`tbl_mapping_action_name` (`id`, `action`, `name`) VALUES ('13', 'update', '后端-撰写操作-update');
INSERT INTO `flink_monitor`.`tbl_mapping_action_name` (`id`, `action`, `name`) VALUES ('14', 'answer', '后端-撰写操作-answer');
INSERT INTO `flink_monitor`.`tbl_mapping_action_name` (`id`, `action`, `name`) VALUES ('15', 'like', '后端-互动操作-like');
INSERT INTO `flink_monitor`.`tbl_mapping_action_name` (`id`, `action`, `name`) VALUES ('16', 'comment', '后端-互动操作-comment');
INSERT INTO `flink_monitor`.`tbl_mapping_action_name` (`id`, `action`, `name`) VALUES ('17', 'collect', '后端-互动操作-collect');