package com.gmei.data.monitor.operator;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.gmei.data.monitor.bean.GmPortraitResult;
import com.gmei.data.monitor.bean.TblMonitorPortraitSuc;
import com.gmei.data.monitor.sink.PortraitSucMysqlSink;
import com.gmei.data.monitor.utils.DateUtils;
import org.apache.flink.api.common.functions.FilterFunction;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.windowing.ProcessWindowFunction;
import org.apache.flink.streaming.api.windowing.time.Time;
import org.apache.flink.streaming.api.windowing.windows.TimeWindow;
import org.apache.flink.util.Collector;

/**
 * @ClassName PortraitMonitorSucOperator
 * @Description: 用户画像成功打点数监控
 * @Author zhaojianwei
 * @Date 2020/3/18
 * @Version V1.0
 **/
public class PortraitMonitorSucOperator implements BaseOperator{
    private DataStream dataStream;
    private int windownSize;
    private int slideSize;
    private String outJdbcUrl;
    private int maxRetry;
    private long retryInteral;
    private int parallelism;

    public PortraitMonitorSucOperator(DataStream dataStream, int windownSize,int slideSize,String outJdbcUrl, int maxRetry, long retryInteral,int parallelism) {
        this.dataStream = dataStream;
        this.windownSize = windownSize;
        this.slideSize = slideSize;
        this.outJdbcUrl = outJdbcUrl;
        this.maxRetry = maxRetry;
        this.retryInteral = retryInteral;
        this.parallelism = parallelism;
    }

    @Override
    public void run() {
        dataStream
            .map(new MapFunction<String, GmPortraitResult>() {
                @Override
                public GmPortraitResult map(String value) {
                    try{
                        JSONObject jsonObject = JSONObject.parseObject(value);
                        GmPortraitResult gmPortraitResult = JSON.toJavaObject(jsonObject, GmPortraitResult.class);
                        if(null == gmPortraitResult){
                            return new GmPortraitResult();
                        }
                        return gmPortraitResult;
                    }catch (Exception e){
                        e.printStackTrace();
                        return new GmPortraitResult();
                    }
                }
            })
            .filter(new FilterFunction<GmPortraitResult>() {
                @Override
                public boolean filter(GmPortraitResult value) throws Exception {
                    if(null == value.getAction() || null == value.getDevice_id() || null == value.getLog_time()){
                        return false;
                    }
                    return true;
                }
            })
            .keyBy("action")
            .timeWindow(Time.seconds(windownSize),Time.seconds(slideSize))
            .process(new ProcessWindowFunction<GmPortraitResult, TblMonitorPortraitSuc, Tuple, TimeWindow>() {
                @Override
                public void process(Tuple key, Context context, Iterable<GmPortraitResult> elements, Collector<TblMonitorPortraitSuc> out) {
                    Integer count = 0;
                    for (GmPortraitResult element : elements) {
                        ++ count;
                    }
                    String monitorTime = DateUtils.getCurrentTimeStr();
                    TblMonitorPortraitSuc tblMonitorPortraitSuc = new TblMonitorPortraitSuc(key.getField(0), count, monitorTime);
                    out.collect(tblMonitorPortraitSuc);
                }
            })
            .addSink(new PortraitSucMysqlSink(outJdbcUrl,maxRetry,retryInteral))
            .setParallelism(parallelism);
    }
}
