package com.gmei.data.monitor.sink;

import com.gmei.data.monitor.utils.JDBCUtils;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.sink.RichSinkFunction;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;

/**
 * @ClassName PortraitErrMysqlSink
 * @Description: 用户画像异常数据解析MysqlSink
 * @Author zhaojianwei
 * @Date 2020/3/18
 * @Version V1.0
 **/
public class PortraitErrMysqlSink extends RichSinkFunction<Tuple2<String,String>> {

    private String jdbcUrl;
    private int maxRetry;
    private long retryInteral;
    private Connection connection;

    public PortraitErrMysqlSink(String jdbcUrl,int maxRetry, long retryInteral) {
        this.jdbcUrl = jdbcUrl;
        this.maxRetry = maxRetry;
        this.retryInteral = retryInteral;
    }

    @Override
    public void open(Configuration parameters) throws Exception {
        Class.forName("com.mysql.jdbc.Driver");
        connection = DriverManager.getConnection(jdbcUrl);
        super.open(parameters);
    }

    @Override
    public void invoke(Tuple2<String,String> tuple2, Context context) throws Exception {
        try {
            insert(tuple2);
        }catch (Exception e){
            e.printStackTrace();
            int numReties = 1;
            Exception lastException = e;
            while (numReties <= maxRetry){
                try {
                    numReties++;
                    Thread.sleep(retryInteral);
                    insert(tuple2);
                }catch (Exception e1){
                    lastException = e1;
                    continue;
                }
                return;
            }
            throw lastException;
        }
    }

    @Override
    public void close() throws Exception {
        JDBCUtils.close(connection,null,null);
        super.close();
    }

    /**
     * 数据写入方法
     * @param tuple2
     * @throws SQLException
     */
    private void insert(Tuple2<String,String> tuple2) throws SQLException {
        Statement statement = connection.createStatement();
        statement.executeUpdate(String.format("insert into tbl_monitor_portrait_err(log_content,monitor_time) values('%s','%s')",
                tuple2.f0,
                tuple2.f1)
        );
        JDBCUtils.close(null,statement,null);
    }
}
