package com.gmei.data.monitor.sink;


import com.gmei.data.monitor.bean.TblMonitorPortraitShd;
import com.gmei.data.monitor.utils.JDBCUtils;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.sink.RichSinkFunction;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;

/**
 * @ClassName PortraitShdMysqlSink
 * @Description: 用户画像计划数据解析MysqlSink
 * @Author zhaojianwei
 * @Date 2020/3/18
 * @Version V1.0
 **/
public class PortraitShdMysqlSink extends RichSinkFunction<TblMonitorPortraitShd> {

    private String jdbcUrl;
    private int maxRetry;
    private long retryInteral;
    private Connection connection;

    public PortraitShdMysqlSink(String jdbcUrl, int maxRetry, long retryInteral) {
        this.jdbcUrl = jdbcUrl;
        this.maxRetry = maxRetry;
        this.retryInteral = retryInteral;
    }

    @Override
    public void open(Configuration parameters) throws Exception {
        Class.forName("com.mysql.jdbc.Driver");
        connection = DriverManager.getConnection(jdbcUrl);
        super.open(parameters);
    }

    @Override
    public void invoke(TblMonitorPortraitShd tblMonitorPortraitShd, Context context) throws Exception {
        try {
            insert(tblMonitorPortraitShd);
        }catch (Exception e){
            e.printStackTrace();
            int numReties = 1;
            Exception lastException = e;
            while (numReties <= maxRetry){
                try {
                    numReties++;
                    Thread.sleep(retryInteral);
                    insert(tblMonitorPortraitShd);
                }catch (Exception e1){
                    lastException = e1;
                    continue;
                }
                return;
            }
            throw lastException;
        }
    }

    @Override
    public void close() throws Exception {
        JDBCUtils.close(connection,null,null);
        super.close();
    }

    /**
     * 数据写入方法
     * @param tblMonitorPortraitShd
     * @throws SQLException
     */
    private void insert(TblMonitorPortraitShd tblMonitorPortraitShd) throws SQLException {
        Statement statement = connection.createStatement();
        statement.executeUpdate(String.format("insert into tbl_monitor_portrait_shd(action_shd,count_shd,monitor_time) values('%s','%d','%s')",
                tblMonitorPortraitShd.getActionShd(),
                tblMonitorPortraitShd.getCountShd(),
                tblMonitorPortraitShd.getMonitorTime())
        );
        JDBCUtils.close(null,statement,null);
    }
}
