package com.gmei.data.monitor.source;

import com.gmei.data.monitor.schama.GmeiLoggingSchema;
import com.gmei.data.monitor.utils.DateUtils;
import org.apache.flink.api.common.serialization.SimpleStringSchema;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.kafka.clients.consumer.ConsumerConfig;

import java.text.ParseException;

/**
 * @ClassName PortraitKafkaSource
 * @Description: 画像打点数据源
 * @Author zhaojianwei
 * @Date 2020/3/18
 * @Version V1.0
 **/
public class PortraitKafkaSource implements BaseSource{
    private StreamExecutionEnvironment env;
    private String inBrokers;
    private String maidianInTopic;
    private String backendInTopic;
    private String groupId;
    private String batchSize;
    private Boolean isStartFromEarliest;
    private String startTime;

    public PortraitKafkaSource(StreamExecutionEnvironment env,String inBrokers, String maidianInTopic, String backendInTopic,
                               String groupId,String batchSize,Boolean isStartFromEarliest,String startTime) {
        this.env = env;
        this.inBrokers = inBrokers;
        this.maidianInTopic = maidianInTopic;
        this.backendInTopic = backendInTopic;
        this.groupId = groupId;
        this.batchSize = batchSize;
        this.isStartFromEarliest = isStartFromEarliest;
        this.startTime = startTime;
    }

    @Override
    public DataStream getInstance() throws ParseException {
        // 获得埋点日志数据
        GmeiKafkaSource maidianKafkaSource = new GmeiKafkaSource(maidianInTopic);
        maidianKafkaSource.setSource(new SimpleStringSchema());
        maidianKafkaSource.setProp(ConsumerConfig.BOOTSTRAP_SERVERS_CONFIG,inBrokers);
        maidianKafkaSource.setProp(ConsumerConfig.GROUP_ID_CONFIG,groupId);
        maidianKafkaSource.setProp(ConsumerConfig.MAX_POLL_RECORDS_CONFIG,batchSize);

        // 获得后台日志数据
        GmeiKafkaSource backendKafkaSource = new GmeiKafkaSource(backendInTopic);
        backendKafkaSource.setSource(new GmeiLoggingSchema());
        backendKafkaSource.setProp(ConsumerConfig.BOOTSTRAP_SERVERS_CONFIG,inBrokers);
        backendKafkaSource.setProp(ConsumerConfig.GROUP_ID_CONFIG,groupId);
        backendKafkaSource.setProp(ConsumerConfig.MAX_POLL_RECORDS_CONFIG,batchSize);

        if(isStartFromEarliest){
            maidianKafkaSource.getSource().setStartFromEarliest();
            backendKafkaSource.getSource().setStartFromEarliest();
        }else if(startTime != null){
            maidianKafkaSource.getSource().setStartFromTimestamp(DateUtils.getTimestampByDateStr(startTime));
            backendKafkaSource.getSource().setStartFromTimestamp(DateUtils.getTimestampByDateStr(startTime));
        }
        DataStreamSource maidianLogDatas = env.addSource(maidianKafkaSource.getSource());
        DataStreamSource backendLogDatas = env.addSource(backendKafkaSource.getSource());
        return backendLogDatas.union(maidianLogDatas);
    }
}
