package com.gmei.data.monitor.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * @ClassName DateUtils
 * @Description: 时间工具类
 * @Author apple
 * @Date 2020/3/16
 * @Version V1.0
 **/
public class DateUtils {

    private static final String DATE_FORMATE_YMDHMS = "yyyy-MM-dd HH:mm:ss";

    /**
     * 获取当前时间字符串
     * @return
     */
    public static String getCurrentTimeStr() {
        return new SimpleDateFormat(DATE_FORMATE_YMDHMS).format(new Date());
    }

    /**
     * 根据时间字符串获得时间戳
     * @param dateStr
     * @return
     * @throws ParseException
     */
    public static Long getTimestampByDateStr(String dateStr) throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATE_FORMATE_YMDHMS);
        return simpleDateFormat.parse(dateStr).getTime();
    }
}
