#!/bin/bash

export FLINK_HOME=/opt/flink-1.9.0
export JAR_DIR=/srv/apps/flink-monitor/libs
export HADOOP_HOME=/opt/hadoop-2.6.0-cdh5.16.1
export JAVA_OPTS="-Xms1024m -Xmx8192m -XX:-UseGCOverheadLimit -XX:+UseConcMarkSweepGC"

$FLINK_HOME/bin/flink run  \
-m yarn-cluster \
-ynm portrait-monitor \
-yqu flink \
-yn 2 \
-ys 2 \
-p 4 \
-yjm 1024 \
-ytm 2048 \
$JAR_DIR/flink-monitor-1.0-SNAPSHOT.jar \
--inBrokers '172.16.44.25:9092,172.16.44.31:9092,172.16.44.45:9092' \
--batchSize 1000 \
--maidianInTopic 'gm-maidian-data' \
--backendInTopic 'gm-logging-prod' \
--portraitSucInTopic 'gm-portrait-result' \
--portraitErrGroupId 'flink_monitor_err' \
--portraitShdGroupId 'flink_monitor_shd' \
--portraitSucGroupId 'flink_monitor_suc' \
--windowSize 60 \
--slideSize 60 \
--outJdbcUrl 'jdbc:mysql://172.18.44.3:3306/flink_monitor?user=root&password=5OqYM^zLwotJ3oSo&autoReconnect=true&useSSL=false' \
--maxRetry 3 \
--retryInteral 3000 \
--checkpointPath 'hdfs://bj-gmei-hdfs/user/data/flink/flink-monitor/checkpoint' \
--parallelism 10


#$FLINK_HOME/bin/flink run  \
#-m yarn-cluster \
#-yn 3 \
#-ynm portrait_monitor \
#-yqu flink \
#-p 6 \
#-yjm 1024 \
#-ytm 2048 \
#-ys 2 \
#$JAR_DIR/flink-monitor-1.0-SNAPSHOT.jar \
#--inBrokers 'test003:9092' \
#--batchSize 1000 \
#--maidianInTopic 'test11' \
#--backendInTopic 'test12' \
#--portraitSucTopic 'test13' \
#--portraitErrGroupId 'flink_monitor_err' \
#--portraitShdGroupId 'flink_monitor_shd' \
#--portraitSucGroupId 'flink_monitor_suc' \
#--windowSize 3 \
#--slideSize 3 \
#--outJdbcUrl 'jdbc:mysql://test002:3306/flink_monitor?user=root&password=5OqYM^zLwotJ3oSo&autoReconnect=true&useSSL=false' \
#--maxRetry 1 \
#--retryInteral 1000 \
#--checkpointPath 'hdfs://bj-test-gmei-hdfs/user/data/flink/bl_hdfs_maidian_open/checkpoint' \
#--isStartFromEarliest false \
#--startTime '2020-03-18 00:00:00' \
#--parallelism 10