package com.gmei.data.monitor.sink;

import com.gmei.data.monitor.bean.TblMonitorPortraitSuc;
import com.gmei.data.monitor.utils.JDBCUtils;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.sink.RichSinkFunction;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;

/**
 * @ClassName PortraitSucMysqlSink
 * @Description: 用户画像成功打点MysqlSink
 * @Author zhaojianwei
 * @Date 2020/3/18
 * @Version V1.0
 **/
public class PortraitSucMysqlSink extends RichSinkFunction<TblMonitorPortraitSuc> {
    private String jdbcUrl;
    private int maxRetry;
    private long retryInteral;
    private Connection connection;

    public PortraitSucMysqlSink(String jdbcUrl, int maxRetry, long retryInteral) {
        this.jdbcUrl = jdbcUrl;
        this.maxRetry = maxRetry;
        this.retryInteral = retryInteral;
    }

    @Override
    public void open(Configuration parameters) throws Exception {
        Class.forName("com.mysql.jdbc.Driver");
        connection = DriverManager.getConnection(jdbcUrl);
        super.open(parameters);
    }

    @Override
    public void invoke(TblMonitorPortraitSuc tblMonitorPortraitSuc, Context context) throws Exception {
        try {
            insert(tblMonitorPortraitSuc);
        }catch (Exception e){
            e.printStackTrace();
            int numReties = 1;
            Exception lastException = e;
            while (numReties <= maxRetry){
                try {
                    numReties++;
                    Thread.sleep(retryInteral);
                    insert(tblMonitorPortraitSuc);
                }catch (Exception e1){
                    lastException = e1;
                    continue;
                }
                return;
            }
            throw lastException;
        }
    }

    @Override
    public void close() throws Exception {
        JDBCUtils.close(connection,null,null);
        super.close();
    }

    /**
     * 数据写入方法
     * @param tblMonitorPortraitSuc
     * @throws SQLException
     */
    private void insert(TblMonitorPortraitSuc tblMonitorPortraitSuc) throws SQLException {
        Statement statement = connection.createStatement();
        statement.executeUpdate(String.format("insert into tbl_monitor_portrait_suc(action_suc,count_suc,monitor_time) values('%s','%d','%s')",
                tblMonitorPortraitSuc.getActionSuc(),
                tblMonitorPortraitSuc.getCountSuc(),
                tblMonitorPortraitSuc.getMonitorTime())
        );
        JDBCUtils.close(null,statement,null);
    }
}
