package com.gmei.data.monitor.source;

import com.gmei.data.monitor.utils.DateUtils;
import org.apache.flink.api.common.serialization.SimpleStringSchema;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.kafka.clients.consumer.ConsumerConfig;

import java.text.ParseException;
import java.text.SimpleDateFormat;

/**
 * @ClassName PortraitSucKafkaSource
 * @Description: 画像打点结果数据源
 * @Author zhaojianwei
 * @Date 2020/3/18
 * @Version V1.0
 **/
public class PortraitSucKafkaSource implements BaseSource{
    private StreamExecutionEnvironment env;
    private String inBrokers;
    private String topic;
    private String groupId;
    private String batchSize;
    private Boolean isStartFromEarliest;
    private String startTime;

    public PortraitSucKafkaSource(StreamExecutionEnvironment env, String inBrokers, String topic, String groupId,
                                  String batchSize,Boolean isStartFromEarliest,String startTime) {
        this.env = env;
        this.inBrokers = inBrokers;
        this.topic = topic;
        this.groupId = groupId;
        this.batchSize = batchSize;
        this.isStartFromEarliest = isStartFromEarliest;
        this.startTime = startTime;
    }

    @Override
    public DataStream getInstance() throws ParseException {
        // 获得埋点日志数据
        GmeiKafkaSource gmeiKafkaSource = new GmeiKafkaSource(topic);
        gmeiKafkaSource.setSource(new SimpleStringSchema());
        gmeiKafkaSource.setProp(ConsumerConfig.BOOTSTRAP_SERVERS_CONFIG,inBrokers);
        gmeiKafkaSource.setProp(ConsumerConfig.GROUP_ID_CONFIG,groupId);
        gmeiKafkaSource.setProp(ConsumerConfig.MAX_POLL_RECORDS_CONFIG,batchSize);

        if(isStartFromEarliest){
            gmeiKafkaSource.getSource().setStartFromEarliest();
        }else if(startTime != null){
            gmeiKafkaSource.getSource().setStartFromTimestamp(DateUtils.getTimestampByDateStr(startTime));
        }
        return env.addSource(gmeiKafkaSource.getSource());
    }
}
