import requests
from gm_upload import upload, upload_file
from gm_upload import IMG_TYPE
import io
from PIL import Image
# import numpy as np


def upload_image(url, img_type=IMG_TYPE.TOPIC):
    '''非站内图片处理'''
    try:
        response = requests.get(url)
        return upload(response.content, img_type=img_type)
    except:
        return None


def upload_weibo_image(url, img_type=IMG_TYPE.TOPIC):
    '''非站内图片处理'''
    try:
        response = requests.get(url)
        img = Image.open(io.BytesIO(response.content))

        w, h = img.size
        img = img.crop((0, 0, w, h-10))

        # img =  img.convert('RGB')
        # content =  np.array(img)[..., ::-1]
        temp = io.BytesIO()
        # content = Image.fromarray(content)
        img.save(temp, format="png")
        content = temp.getvalue()

        return upload(content, img_type=img_type)
    except:
        return None
