
from api.views.base_view import BaseView


class UpdateGraspStatus(BaseView):
    """
    更新用户爬取状态
    """
    def post(self, request):
        user_id = int(request.POST.get("user_id", 0))
        relation_account_id = request.POST.get("relation_account_id", "")
        error, _data = self.call_rpc(
            "venus/community/user/update_grasp_status",
            user_id=user_id,
            relation_account_id=relation_account_id
        )
        if error:
            return self.error(error)

        return self.ok(data=_data)
